/*
 * Decompiled with CFR 0.152.
 */
package me.head_block.xpbank.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import me.head_block.xpbank.Main;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Utils {
    public static int getMaxLevel(Player sender, int xpStored) {
        int totalXp = Utils.totalXp(sender.getLevel(), Utils.xpPointsInBar(sender.getExp(), sender.getExpToLevel()));
        return Utils.level(totalXp += xpStored);
    }

    public static int totalXp(int level, int xp) {
        int total = 0;
        if (level <= 16) {
            total = level * level + 6 * level;
        } else if (level <= 31) {
            total = (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        } else if (level >= 32) {
            total = (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        return total += xp;
    }

    public static int totalXp(Player p) {
        return Utils.totalXp(p.getLevel(), Utils.xpPointsInBar(p.getExp(), p.getExpToLevel()));
    }

    public static int totalXp(int level) {
        int total = 0;
        if (level < 16) {
            total = level * level + 6 * level;
        } else if (level < 31) {
            total = (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        } else if (level > 31) {
            total = (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        return total;
    }

    public static int xpPointsInBar(float xp, int xpToLevelUp) {
        return (int)(xp * (float)xpToLevelUp);
    }

    public static int level(int totalXp) {
        int level = 0;
        if (totalXp <= 352) {
            level = (int)(Math.sqrt(totalXp + 9) - 3.0);
        } else if (totalXp <= 1507) {
            level = (int)(8.1 + (double)((float)Math.sqrt((double)0.4f * ((double)totalXp - 195.975))));
        } else if (totalXp >= 1508) {
            level = (int)(18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)totalXp - 752.9861111111111)));
        }
        return level;
    }

    public static float xp(int totalXp) {
        int level = Utils.level(totalXp);
        int newTotal = totalXp - Utils.totalXp(level);
        return Utils.xpToLevelUp(level) / newTotal;
    }

    public static float xp(int totalXp, int level) {
        int newTotal = totalXp - Utils.totalXp(level);
        return (float)newTotal / (float)Utils.xpToLevelUp(level);
    }

    public static int xpToLevelUp(int level) {
        if (level < 16) {
            return 2 * level + 7;
        }
        if (level < 31) {
            return 5 * level - 38;
        }
        if (level > 31) {
            return 9 * level - 158;
        }
        return -1;
    }

    public static void save(Object o, File f) {
        try {
            FileOutputStream stream = new FileOutputStream(f.getAbsoluteFile());
            ObjectOutputStream output = new ObjectOutputStream(stream);
            output.writeObject(o);
            output.close();
            return;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static Object load(File f) {
        try {
            FileInputStream stream = new FileInputStream(f.getAbsolutePath());
            ObjectInputStream input = new ObjectInputStream(stream);
            Object object = input.readObject();
            input.close();
            return object;
        }
        catch (IOException e) {
            Bukkit.broadcastMessage((String)("Error loading" + e.getMessage()));
            return null;
        }
        catch (ClassNotFoundException e) {
            Bukkit.broadcastMessage((String)("Error loading" + e.getMessage()));
            return null;
        }
    }

    public static void bubbleSort(ArrayList<String> list) {
        if (list == null) {
            return;
        }
        boolean sorted = true;
        int i = list.size() - 1;
        while (i >= 0) {
            sorted = true;
            int j = 0;
            while (j < i) {
                String item1 = list.get(j);
                String item2 = list.get(j + 1);
                if (Main.xps.get(list.get(j)) < Main.xps.get(list.get(j + 1))) {
                    sorted = false;
                    list.set(j, item2);
                    list.set(j + 1, item1);
                }
                ++j;
            }
            if (sorted) {
                return;
            }
            --i;
        }
    }

    public static ItemStack createItem(Material type, int count, String displayName, String ... lore) {
        ItemStack toReturn = new ItemStack(type, count);
        ItemMeta meta = toReturn.getItemMeta();
        if (displayName != null) {
            meta.setDisplayName(displayName);
        }
        if (lore.length != 1 || lore[0] != "") {
            ArrayList<String> loreList = new ArrayList<String>();
            String[] stringArray = lore;
            int n = lore.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                loreList.add(s);
                ++n2;
            }
            meta.setLore(loreList);
        }
        toReturn.setItemMeta(meta);
        return toReturn;
    }

    public static ItemStack setLore(ItemStack i, String ... lore) {
        ItemMeta meta = i.getItemMeta();
        if (lore.length != 1 || lore[0] != "") {
            ArrayList<String> loreList = new ArrayList<String>();
            String[] stringArray = lore;
            int n = lore.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                loreList.add(s);
                ++n2;
            }
            meta.setLore(loreList);
        }
        i.setItemMeta(meta);
        return i;
    }

    public static ItemStack setLore(ItemStack item, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        if (lore == null || lore.isEmpty()) {
            return item;
        }
        ArrayList<String> loreList = new ArrayList<String>();
        for (String s : lore) {
            loreList.add(s);
        }
        meta.setLore(loreList);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack setLoreLine(ItemStack i, int line, String lore) {
        ItemMeta meta = i.getItemMeta();
        ArrayList<String> loreList = meta.hasLore() ? meta.getLore() : new ArrayList<String>();
        loreList.set(line, lore);
        meta.setLore(loreList);
        i.setItemMeta(meta);
        return i;
    }

    public static ItemStack setDisplayName(ItemStack i, String name) {
        ItemMeta meta = i.getItemMeta();
        meta.setDisplayName(name);
        i.setItemMeta(meta);
        return i;
    }

    public static ItemStack addLore(ItemStack i, String ... lore) {
        ItemMeta meta = i.getItemMeta();
        if (lore.length != 1 || lore[0] != "") {
            ArrayList<String> loreList = meta.hasLore() ? meta.getLore() : new ArrayList<String>();
            String[] stringArray = lore;
            int n = lore.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                loreList.add(s);
                ++n2;
            }
            meta.setLore(loreList);
        }
        i.setItemMeta(meta);
        return i;
    }

    public static String replacePlaceholders(String text) {
        text = text.replace("%MAX_LEVEL_HELD%", Utils.formatNumber(Main.MAX_LEVEL_HELD));
        text = text.replace("%MAX_LEVEL_STORED%", Utils.formatNumber(Main.MAX_LEVEL_STORED));
        text = text.replace("%MAX_XP_HELD%", Utils.formatNumber(Main.MAX_XP_HELD));
        text = text.replace("%MAX_XP_STORED%", Utils.formatNumber(Main.MAX_XP_STORED));
        text = text.replace("%MAX_LEVEL_HELD_RAW%", "" + Main.MAX_LEVEL_HELD);
        text = text.replace("%MAX_LEVEL_STORED_RAW%", "" + Main.MAX_LEVEL_STORED);
        text = text.replace("%MAX_XP_HELD_RAW%", "" + Main.MAX_XP_HELD);
        text = text.replace("%MAX_XP_STORED_RAW%", "" + Main.MAX_XP_STORED);
        return text;
    }

    public static String replacePlaceholders(String text, OfflinePlayer p) {
        text = Utils.replacePlaceholders(text);
        Utils.checkBalInstance(p);
        text = text.replace("%XP_STORED%", Utils.formatNumber(Main.xps.get(p.getUniqueId().toString())));
        text = text.replace("%XP_STORED_RAW%", "" + Main.xps.get(p.getUniqueId().toString()));
        if (p.isOnline()) {
            text = text.replace("%XP_HELD%", Utils.formatNumber(Utils.totalXp(p.getPlayer())));
            text = text.replace("%TOTAL_XP%", Utils.formatNumber(Utils.totalXp(p.getPlayer()) + Main.xps.get(p.getUniqueId().toString())));
            text = text.replace("%TOTAL_XP_LEVEL%", Utils.formatNumber(Utils.getMaxLevel(p.getPlayer(), Main.xps.get(p.getPlayer().getUniqueId().toString()))));
            text = text.replace("%XP_HELD_RAW%", "" + Utils.totalXp(p.getPlayer()));
            text = text.replace("%TOTAL_XP_RAW%", "" + (Utils.totalXp(p.getPlayer()) + Main.xps.get(p.getUniqueId().toString())));
            text = text.replace("%TOTAL_XP_LEVEL_RAW%", "" + Utils.getMaxLevel(p.getPlayer(), Main.xps.get(p.getPlayer().getUniqueId().toString())));
        }
        return text;
    }

    public static void checkBalInstance(OfflinePlayer p) {
        if (!Main.xps.containsKey(p.getUniqueId().toString())) {
            Main.xps.put(p.getUniqueId().toString(), 0);
        }
    }

    public static String formatNumber(int num) {
        int length = ("" + num).length();
        String toReturn = "" + num;
        if (length >= 4 && length < 7) {
            toReturn = Utils.trunc((double)num / 1000.0, 2) + "K";
        } else if (length >= 7 && length < 10) {
            toReturn = Utils.trunc((double)num / 1000000.0, 2) + "M";
        } else if (length >= 10 && length < 14) {
            toReturn = Utils.trunc((double)num / 1.0E9, 2) + "B";
        }
        return toReturn;
    }

    public static double trunc(double d, int decimalsToKeep) {
        d *= Math.pow(10.0, decimalsToKeep);
        d = (int)d;
        return d /= Math.pow(10.0, decimalsToKeep);
    }
}

