/*
 * Decompiled with CFR 0.152.
 */
package me.head_block.xpbank.ui;

import java.util.List;
import me.head_block.xpbank.Main;
import me.head_block.xpbank.commands.Xp;
import me.head_block.xpbank.ui.MainMenu;
import me.head_block.xpbank.utils.Utils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DepositMenu {
    public static String INV_NAME;
    public static final int INV_SIZE = 18;
    public static ItemStack[] UIinventory;
    private static ItemStack deposit25;
    private static ItemStack deposit50;
    private static ItemStack deposit75;
    private static ItemStack deposit100;
    private static ItemStack depositMax;
    private static ItemStack deposit1L;
    private static ItemStack deposit5L;
    private static ItemStack deposit10L;
    private static ItemStack deposit15L;

    public static void init() {
        INV_NAME = ChatColor.translateAlternateColorCodes((char)'&', (String)Main.instance.getConfig().getString("gui.deposit-menu.name"));
        UIinventory = new ItemStack[18];
        DepositMenu.UIinventory[0] = deposit25 = DepositMenu.loadItem("gui.deposit-menu.25-percent");
        DepositMenu.UIinventory[1] = deposit50 = DepositMenu.loadItem("gui.deposit-menu.50-percent");
        DepositMenu.UIinventory[2] = deposit75 = DepositMenu.loadItem("gui.deposit-menu.75-percent");
        DepositMenu.UIinventory[3] = deposit100 = DepositMenu.loadItem("gui.deposit-menu.75-percent");
        DepositMenu.UIinventory[5] = deposit1L = DepositMenu.loadItem("gui.deposit-menu.1-level");
        DepositMenu.UIinventory[6] = deposit5L = DepositMenu.loadItem("gui.deposit-menu.5-levels");
        DepositMenu.UIinventory[7] = deposit10L = DepositMenu.loadItem("gui.deposit-menu.10-levels");
        DepositMenu.UIinventory[8] = deposit15L = DepositMenu.loadItem("gui.deposit-menu.15-levels");
        DepositMenu.UIinventory[4] = depositMax = DepositMenu.loadItem("gui.deposit-menu.max");
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta iMeta = back.getItemMeta();
        iMeta.setDisplayName(ChatColor.RED + ChatColor.BOLD + "Back");
        back.setItemMeta(iMeta);
        DepositMenu.UIinventory[17] = back;
    }

    private static ItemStack loadItem(String path) {
        ItemStack item = Main.instance.getConfig().getItemStack(path).clone();
        if (item.hasItemMeta()) {
            String name = item.getItemMeta().getDisplayName();
            name = Utils.replacePlaceholders(name);
            name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            Utils.setDisplayName(item, name);
        }
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            List lore = item.getItemMeta().getLore();
            int i = 0;
            while (i < lore.size()) {
                String loreLine = Utils.replacePlaceholders((String)lore.get(i));
                lore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)loreLine));
                ++i;
            }
            Utils.setLore(item, lore);
        }
        return item;
    }

    public static void openForPlayer(Player p) {
        Inventory toOpen = Bukkit.createInventory(null, (int)18, (String)INV_NAME);
        toOpen.setContents(UIinventory);
        p.openInventory(toOpen);
    }

    public static void clicked(Player p, int slot, ItemStack clicked, Inventory inv) {
        if (clicked.getType().equals((Object)Material.BARRIER) && slot < 18) {
            MainMenu.openForPlayer(p);
        }
        if (slot < 18 && clicked.hasItemMeta() && clicked.getItemMeta().hasDisplayName()) {
            double percentage = 0.0;
            if (clicked.equals((Object)deposit25)) {
                percentage = 0.25;
            } else if (clicked.equals((Object)deposit50)) {
                percentage = 0.5;
            } else if (clicked.equals((Object)deposit75)) {
                percentage = 0.75;
            } else if (clicked.equals((Object)deposit100)) {
                percentage = 1.0;
            }
            if (percentage > 0.0) {
                int totalXP = Utils.totalXp(p);
                int points = (int)((double)totalXP * percentage);
                Utils.checkBalInstance((OfflinePlayer)p);
                if (points == 0) {
                    p.sendMessage(Utils.replacePlaceholders(Xp.NO_XP_DEPOSIT_MESSAGE, (OfflinePlayer)p));
                } else if ((long)Main.xps.get(p.getUniqueId().toString()).intValue() + (long)points > (long)Main.MAX_XP_STORED) {
                    p.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT));
                } else {
                    DepositMenu.removeXp(points, p, totalXP);
                    long oldBal = Main.xps.get(p.getUniqueId().toString()).intValue();
                    Main.xps.put(p.getUniqueId().toString(), (int)(oldBal + (long)points));
                    p.sendMessage(Utils.replacePlaceholders(Xp.DEPOSIT_MESSAGE));
                }
                return;
            }
            int amount = 0;
            if (clicked.equals((Object)deposit1L)) {
                amount = 1;
            } else if (clicked.equals((Object)deposit15L)) {
                amount = 15;
            } else if (clicked.equals((Object)deposit10L)) {
                amount = 10;
            } else if (clicked.equals((Object)deposit5L)) {
                amount = 5;
            }
            if (amount > 0) {
                Utils.checkBalInstance((OfflinePlayer)p);
                if ((long)Main.xps.get(p.getUniqueId().toString()).intValue() + (long)Utils.totalXp(amount) > (long)Main.MAX_XP_STORED) {
                    p.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT, (OfflinePlayer)p));
                } else if (p.getLevel() < amount) {
                    p.sendMessage(ChatColor.RED + "You don't have that many levels");
                } else {
                    int xpToLose = Utils.totalXp(p.getLevel()) - Utils.totalXp(p.getLevel() - amount);
                    DepositMenu.removeXp(xpToLose, p, Utils.totalXp(p));
                    int oldBal = Main.xps.get(p.getUniqueId().toString());
                    Main.xps.put(p.getUniqueId().toString(), oldBal + xpToLose);
                    p.sendMessage(Utils.replacePlaceholders(Xp.DEPOSIT_MESSAGE, (OfflinePlayer)p));
                }
                return;
            }
            if (clicked.equals((Object)depositMax)) {
                int totalXP = Utils.totalXp(p);
                if (totalXP == 0) {
                    p.sendMessage(Utils.replacePlaceholders(Xp.NO_XP_DEPOSIT_MESSAGE, (OfflinePlayer)p));
                    return;
                }
                int points = totalXP;
                if (Main.xps.get(p.getUniqueId().toString()) + points >= Main.MAX_XP_STORED) {
                    points = Main.MAX_XP_STORED - Main.xps.get(p.getUniqueId().toString());
                }
                if (points == 0) {
                    p.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT, (OfflinePlayer)p));
                    return;
                }
                Utils.checkBalInstance((OfflinePlayer)p);
                if ((long)Main.xps.get(p.getUniqueId().toString()).intValue() + (long)points > (long)Main.MAX_XP_STORED) {
                    p.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT, (OfflinePlayer)p));
                } else {
                    DepositMenu.removeXp(points, p, totalXP);
                    long oldBal = Main.xps.get(p.getUniqueId().toString()).intValue();
                    Main.xps.put(p.getUniqueId().toString(), (int)(oldBal + (long)points));
                    p.sendMessage(Utils.replacePlaceholders(Xp.DEPOSIT_MESSAGE, (OfflinePlayer)p));
                }
                return;
            }
        }
    }

    private static void removeXp(int xp, Player p, int playerTotalXp) {
        int newTotal = playerTotalXp - xp;
        int newLevel = Utils.level(newTotal);
        float newXp = Utils.xp(newTotal, newLevel);
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }
}

