/*
 * Decompiled with CFR 0.152.
 */
package me.head_block.xpbank.commands;

import me.head_block.xpbank.Main;
import me.head_block.xpbank.ui.MainMenu;
import me.head_block.xpbank.utils.Utils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Xp
implements CommandExecutor {
    public static final String HELP_MESSAGE = ChatColor.GRAY + "------------ " + ChatColor.YELLOW + "/xpbank help" + ChatColor.GRAY + " ------------\n" + ChatColor.GRAY + "/xpbank - " + ChatColor.AQUA + "Tells you how much xp you have stored or opens the XpBank GUI\n" + ChatColor.GRAY + "/xpbank xpheld - " + ChatColor.AQUA + "Tells you how much xp you are holding\n" + ChatColor.GRAY + "/xpbank xpstored - " + ChatColor.AQUA + "Tells you how much xp you have stored\n" + ChatColor.GRAY + "/xpbank totalxp - " + ChatColor.AQUA + "Tells you how much xp you have stored and held together\n" + ChatColor.GRAY + "/xpbank deposit <amount> - " + ChatColor.AQUA + "Deposits <amount> xp points\n" + ChatColor.GRAY + "/xpbank deposit <amount> <levels/points> - " + ChatColor.AQUA + "Deposits <amount> points or levels\n" + ChatColor.GRAY + "/xpbank deposit max - " + ChatColor.AQUA + "Deposits all xp up to the max (" + "%MAX_XP_STORED%" + " points)\n" + ChatColor.GRAY + "/xpbank withdraw <amount> - " + ChatColor.AQUA + "Withdraws <amount> xp points\n" + ChatColor.GRAY + "/xpbank withdraw <amount> <levels/points> - " + ChatColor.AQUA + "Withdraws <amount> points or levels\n" + ChatColor.GRAY + "/xpbank withdraw max - " + ChatColor.AQUA + "Withdraws all xp up to the max (" + "%MAX_XP_HELD%" + " points)\n" + ChatColor.GRAY + "/xpbank pay <player> <amount> - " + ChatColor.AQUA + "Pays <player> the specified amount";
    public static final String ADMIN_HELP_MESSAGE = ChatColor.GRAY + "------------ " + ChatColor.YELLOW + "/xpbank admin help" + ChatColor.GRAY + " ------------\n" + ChatColor.GRAY + "/xpbank set <player> <amount> - " + ChatColor.AQUA + "Sets <player>'s balance to <amount>\n" + ChatColor.GRAY + "/xpbank add <player> <amount> - " + ChatColor.AQUA + "Adds <amount> to <player>'s balance\n" + ChatColor.GRAY + "/xpbank remove <player> <amount> - " + ChatColor.AQUA + "Removes <amount> from <player>'s balance capping out at 0\n" + ChatColor.GRAY + "/xpbank reload - " + ChatColor.AQUA + "Reloads config values. (Will not enable/disable commands)";
    public static String INFO_MESSAGE;
    public static String DEPOSIT_MESSAGE;
    public static String WITHDRAW_MESSAGE;
    public static String PLAYER_NOT_FOUND_MESSAGE;
    public static String XP_STORED_MESSAGE;
    public static String XP_HELD_MESSAGE;
    public static String NO_XP_DEPOSIT_MESSAGE;
    public static String NO_XP_WITHDRAW_MESSAGE;
    public static String TOTAL_XP_MESSAGE;

    static {
        DEPOSIT_MESSAGE = ChatColor.GREEN + "Xp deposited. New balance: " + "%XP_STORED%";
        WITHDRAW_MESSAGE = ChatColor.GREEN + "Xp withdrawn. New balance: " + "%XP_STORED%";
        PLAYER_NOT_FOUND_MESSAGE = ChatColor.RED + "Player not found.";
        XP_STORED_MESSAGE = ChatColor.YELLOW + "You have " + "%XP_STORED%" + " experience points in the bank. (Enough for level " + "%TOTAL_XP_LEVEL%" + ")";
        XP_HELD_MESSAGE = ChatColor.YELLOW + "You are holding " + "%XP_HELD%" + " xp";
        NO_XP_DEPOSIT_MESSAGE = ChatColor.RED + "You don't have any XP to deposit";
        NO_XP_WITHDRAW_MESSAGE = ChatColor.RED + "You don't have any XP to withdraw";
        TOTAL_XP_MESSAGE = ChatColor.YELLOW + "Your total xp held and in the bank is: " + "%TOTAL_XP%";
    }

    public Xp(Main plugin) {
        plugin.getCommand("xpbank").setExecutor((CommandExecutor)this);
        INFO_MESSAGE = ChatColor.GRAY + "------------ " + ChatColor.YELLOW + "/xpbank info" + ChatColor.GRAY + " ------------\n" + ChatColor.GRAY + "Plugin version: " + ChatColor.AQUA + Main.instance.getDescription().getVersion() + ChatColor.GRAY + " (Newest version: " + ChatColor.AQUA + Main.newestVersion + ChatColor.GRAY + ")\n" + "Spigot page: " + ChatColor.AQUA + "https://www.spigotmc.org/resources/xpbank.101132/ \n" + ChatColor.GRAY + "Wiki page: " + ChatColor.AQUA + "https://github.com/ACM02/XpBank/wiki";
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            this.asPlayer((Player)sender, args);
        } else {
            this.asConsole(sender, args);
        }
        return false;
    }

    private void asPlayer(Player sender, String[] args) {
        if (!sender.hasPermission("xpbank.use")) {
            sender.sendMessage(Utils.replacePlaceholders(Main.NO_PERM_MESSAGE, (OfflinePlayer)sender));
            return;
        }
        block0 : switch (args.length) {
            case 0: {
                if (Main.GUI_ENABLED) {
                    MainMenu.openForPlayer(sender);
                    break;
                }
                this.checkBalInstance((OfflinePlayer)sender);
                sender.sendMessage(Utils.replacePlaceholders(XP_STORED_MESSAGE, (OfflinePlayer)sender));
                break;
            }
            case 1: {
                switch (args[0]) {
                    case "help": {
                        sender.sendMessage(Utils.replacePlaceholders(HELP_MESSAGE, (OfflinePlayer)sender));
                    }
                    case "adminhelp": {
                        if (!sender.hasPermission("xpbank.admin")) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.NO_PERM_MESSAGE));
                            break block0;
                        }
                        sender.sendMessage(ADMIN_HELP_MESSAGE);
                        break block0;
                    }
                    case "xpheld": {
                        sender.sendMessage(Utils.replacePlaceholders(XP_HELD_MESSAGE, (OfflinePlayer)sender));
                        break block0;
                    }
                    case "xpstored": {
                        sender.sendMessage(Utils.replacePlaceholders(XP_STORED_MESSAGE, (OfflinePlayer)sender));
                        break block0;
                    }
                    case "totalxp": {
                        sender.sendMessage(Utils.replacePlaceholders(TOTAL_XP_MESSAGE, (OfflinePlayer)sender));
                        break block0;
                    }
                    case "reload": {
                        if (!sender.hasPermission("xpbank.admin")) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.NO_PERM_MESSAGE));
                            break block0;
                        }
                        Main.reloadPlugin();
                        sender.sendMessage(ChatColor.GREEN + "Reloaded successfully.");
                        break block0;
                    }
                    case "info": {
                        if (!sender.hasPermission("xpbank.admin")) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.NO_PERM_MESSAGE));
                            break block0;
                        }
                        sender.sendMessage(Utils.replacePlaceholders(ChatColor.GRAY + "------------ " + ChatColor.YELLOW + "/xpbank info" + ChatColor.GRAY + " ------------\n" + ChatColor.GRAY + "Plugin version: " + ChatColor.AQUA + Main.instance.getDescription().getVersion() + ChatColor.GRAY + " (Newest version: " + ChatColor.AQUA + Main.newestVersion + ChatColor.GRAY + ")\n" + "Spigot page: " + ChatColor.AQUA + "https://www.spigotmc.org/resources/xpbank.101132/ \n" + ChatColor.GRAY + "Wiki page: " + ChatColor.AQUA + "https://github.com/ACM02/XpBank/wiki", (OfflinePlayer)sender));
                        break block0;
                    }
                }
                sender.sendMessage(Utils.replacePlaceholders(String.valueOf(Main.IMPROPER_USE_MESSAGE) + "/xpbank help for help"));
                break;
            }
            case 2: {
                switch (args[0]) {
                    case "deposit": {
                        int amount = 1;
                        if (!args[1].equals("max") && (amount = this.getAmount(args[1], sender)) == -1) break;
                        this.checkBalInstance((OfflinePlayer)sender);
                        int playerTotalXp = Utils.totalXp(sender);
                        if (playerTotalXp == 0) {
                            sender.sendMessage(Utils.replacePlaceholders(NO_XP_DEPOSIT_MESSAGE, (OfflinePlayer)sender));
                            break;
                        }
                        if (args[1].equals("max")) {
                            if (Main.xps.get(sender.getUniqueId().toString()) >= Main.MAX_XP_STORED) {
                                sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT));
                                break;
                            }
                            amount = playerTotalXp;
                            if (Main.xps.get(sender.getUniqueId().toString()) + amount >= Main.MAX_XP_STORED) {
                                amount = Main.MAX_XP_STORED - Main.xps.get(sender.getUniqueId().toString());
                            }
                        }
                        if ((long)Main.xps.get(sender.getUniqueId().toString()).intValue() + (long)amount > (long)Main.MAX_XP_STORED) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT));
                            break;
                        }
                        if (amount > playerTotalXp) {
                            sender.sendMessage(ChatColor.RED + "You only have " + playerTotalXp + " xp");
                            break;
                        }
                        this.removeXp(amount, sender, playerTotalXp);
                        int oldBal = Main.xps.get(sender.getUniqueId().toString());
                        Main.xps.put(sender.getUniqueId().toString(), oldBal + amount);
                        sender.sendMessage(Utils.replacePlaceholders(DEPOSIT_MESSAGE, (OfflinePlayer)sender));
                        break;
                    }
                    case "withdraw": {
                        int amount = 0;
                        this.checkBalInstance((OfflinePlayer)sender);
                        if (Main.xps.get(sender.getUniqueId().toString()) == 0) {
                            sender.sendMessage(Utils.replacePlaceholders(NO_XP_WITHDRAW_MESSAGE, (OfflinePlayer)sender));
                            break;
                        }
                        int playerTotalXp = Utils.totalXp(sender);
                        if (args[1].equalsIgnoreCase("max")) {
                            if (playerTotalXp >= Main.MAX_XP_HELD) {
                                sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_HOLD_LIMIT));
                                break;
                            }
                            amount = Main.xps.get(sender.getUniqueId().toString());
                            if (playerTotalXp + amount >= Main.MAX_XP_HELD) {
                                amount = Main.MAX_XP_HELD - playerTotalXp;
                            }
                        } else {
                            amount = this.getAmount(args[1], sender);
                            if (amount == -1) break;
                        }
                        if ((long)playerTotalXp + (long)amount > (long)Main.MAX_XP_HELD) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_HOLD_LIMIT));
                            break;
                        }
                        if (amount > Main.xps.get(sender.getUniqueId().toString())) {
                            sender.sendMessage(Utils.replacePlaceholders(ChatColor.RED + "You only have " + "%XP_HELD%" + " xp in the bank", (OfflinePlayer)sender));
                            break;
                        }
                        this.addXp(amount, sender, playerTotalXp);
                        int oldBal = Main.xps.get(sender.getUniqueId().toString());
                        Main.xps.put(sender.getUniqueId().toString(), oldBal - amount);
                        sender.sendMessage(Utils.replacePlaceholders(WITHDRAW_MESSAGE, (OfflinePlayer)sender));
                        break;
                    }
                    case "get": {
                        if (!sender.hasPermission("xpbank.admin")) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.NO_PERM_MESSAGE));
                            break;
                        }
                        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)args[1]);
                        if (offline == null) {
                            sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                            break;
                        }
                        if (!Main.xps.containsKey(offline.getUniqueId().toString())) {
                            sender.sendMessage(ChatColor.RED + "Player has no balance");
                            break;
                        }
                        if (!Main.xps.containsKey(offline.getUniqueId().toString())) break block0;
                        sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + offline.getName() + "'s stored xp is: " + "%XP_STORED%", offline));
                        break;
                    }
                    default: {
                        sender.sendMessage(Utils.replacePlaceholders(String.valueOf(Main.IMPROPER_USE_MESSAGE) + "/xpbank <deposit/withdraw> <amount>"));
                        break;
                    }
                }
                break;
            }
            case 3: {
                block42 : switch (args[0]) {
                    case "deposit": {
                        int amount = this.getAmount(args[1], sender);
                        if (amount == -1) break;
                        this.checkBalInstance((OfflinePlayer)sender);
                        int playerTotalXp = Utils.totalXp(sender);
                        if (playerTotalXp == 0) {
                            sender.sendMessage(Utils.replacePlaceholders(NO_XP_DEPOSIT_MESSAGE, (OfflinePlayer)sender));
                            break;
                        }
                        switch (args[2]) {
                            case "levels": {
                                if ((long)Main.xps.get(sender.getUniqueId().toString()).intValue() + (long)Utils.totalXp(amount) > (long)Main.MAX_XP_STORED) {
                                    sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT));
                                    break block42;
                                }
                                if (sender.getLevel() < amount) {
                                    sender.sendMessage(ChatColor.RED + "You don't have that many levels");
                                    break block42;
                                }
                                int xpToLose = Utils.totalXp(sender.getLevel()) - Utils.totalXp(sender.getLevel() - amount);
                                this.removeXp(xpToLose, sender, playerTotalXp);
                                int oldBal = Main.xps.get(sender.getUniqueId().toString());
                                Main.xps.put(sender.getUniqueId().toString(), oldBal + xpToLose);
                                sender.sendMessage(Utils.replacePlaceholders(DEPOSIT_MESSAGE, (OfflinePlayer)sender));
                                break block42;
                            }
                            case "points": {
                                if ((long)Main.xps.get(sender.getUniqueId().toString()).intValue() + (long)amount > (long)Main.MAX_XP_STORED) {
                                    sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT));
                                    break block42;
                                }
                                if (amount > playerTotalXp) {
                                    sender.sendMessage(ChatColor.RED + "You only have " + playerTotalXp + " xp");
                                    break block42;
                                }
                                this.removeXp(amount, sender, playerTotalXp);
                                int oldBal = Main.xps.get(sender.getUniqueId().toString());
                                Main.xps.put(sender.getUniqueId().toString(), oldBal + amount);
                                sender.sendMessage(Utils.replacePlaceholders(DEPOSIT_MESSAGE, (OfflinePlayer)sender));
                                break block42;
                            }
                        }
                        sender.sendMessage(Utils.replacePlaceholders(String.valueOf(Main.IMPROPER_USE_MESSAGE) + "/xpbank <deposit/withdraw> <amount> <levels/points>"));
                        break;
                    }
                    case "withdraw": {
                        int amount = this.getAmount(args[1], sender);
                        if (amount == -1) break;
                        this.checkBalInstance((OfflinePlayer)sender);
                        if (Main.xps.get(sender.getUniqueId().toString()) == 0) {
                            sender.sendMessage(Utils.replacePlaceholders(NO_XP_WITHDRAW_MESSAGE, (OfflinePlayer)sender));
                            break;
                        }
                        int playerTotalXp = Utils.totalXp(sender);
                        switch (args[2]) {
                            case "levels": {
                                int xpToAdd = Utils.totalXp(sender.getLevel() + amount) - Utils.totalXp(sender.getLevel());
                                if ((long)playerTotalXp + (long)xpToAdd > (long)Main.MAX_XP_HELD) {
                                    sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_HOLD_LIMIT));
                                    break block42;
                                }
                                if (xpToAdd > Main.xps.get(sender.getUniqueId().toString())) {
                                    sender.sendMessage(ChatColor.RED + "You only have enough xp for " + Utils.getMaxLevel(sender, Main.xps.get(sender.getUniqueId().toString())) + " levels");
                                    break block42;
                                }
                                this.addXp(xpToAdd, sender, playerTotalXp);
                                int oldBal = Main.xps.get(sender.getUniqueId().toString());
                                Main.xps.put(sender.getUniqueId().toString(), oldBal - xpToAdd);
                                sender.sendMessage(Utils.replacePlaceholders(WITHDRAW_MESSAGE, (OfflinePlayer)sender));
                                break block42;
                            }
                            case "points": {
                                if ((long)playerTotalXp + (long)amount > (long)Main.MAX_XP_HELD) {
                                    sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_HOLD_LIMIT));
                                    break block42;
                                }
                                if (amount > Main.xps.get(sender.getUniqueId().toString())) {
                                    sender.sendMessage(Utils.replacePlaceholders(ChatColor.RED + "You only have " + "%XP_STORED%" + " xp in the bank", (OfflinePlayer)sender));
                                    break block42;
                                }
                                this.addXp(amount, sender, playerTotalXp);
                                int oldBal = Main.xps.get(sender.getUniqueId().toString());
                                Main.xps.put(sender.getUniqueId().toString(), oldBal - amount);
                                sender.sendMessage(Utils.replacePlaceholders(WITHDRAW_MESSAGE, (OfflinePlayer)sender));
                                break block42;
                            }
                        }
                        sender.sendMessage(Utils.replacePlaceholders(String.valueOf(Main.IMPROPER_USE_MESSAGE) + "/xpbank <deposit/withdraw> <amount> <levels/points>"));
                        break;
                    }
                    case "pay": {
                        int amount = this.getAmount(args[2], sender);
                        if (amount == -1) break;
                        this.checkBalInstance((OfflinePlayer)sender);
                        if (amount > Main.xps.get(sender.getUniqueId().toString())) {
                            sender.sendMessage(Utils.replacePlaceholders(ChatColor.RED + "You don't have enough xp to do that! (Balance: " + "%XP_STORED" + ")", (OfflinePlayer)sender));
                            break;
                        }
                        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)args[1]);
                        if (offline != null) {
                            if (Main.xps.containsKey(offline.getUniqueId().toString()) && (long)Main.xps.get(offline.getUniqueId().toString()).intValue() + (long)amount > (long)Main.MAX_XP_STORED) {
                                sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT_TARGET));
                                break;
                            }
                            if (Main.xps.containsKey(offline.getUniqueId().toString())) {
                                Main.xps.put(offline.getUniqueId().toString(), Main.xps.get(offline.getUniqueId().toString()) + amount);
                                Main.xps.put(sender.getUniqueId().toString(), Main.xps.get(sender.getUniqueId().toString()) - amount);
                                if (offline.isOnline()) {
                                    Player online = offline.getPlayer();
                                    online.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + sender.getName() + " has sent you " + amount + " xp. New balance: " + "%XP_STORED%", (OfflinePlayer)online));
                                }
                                sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + "Transfer complete. New balance: " + "%XP_STORED%", (OfflinePlayer)sender));
                                break;
                            }
                            if (offline.isOnline()) {
                                Main.xps.put(offline.getUniqueId().toString(), amount);
                                Main.xps.put(sender.getUniqueId().toString(), Main.xps.get(sender.getUniqueId().toString()) - amount);
                                Player online = offline.getPlayer();
                                online.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + sender.getName() + " has sent you " + amount + " xp. New balance: " + "%XP_STORED%", (OfflinePlayer)online));
                                sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + "Transfer complete. New balance: " + "%XP_STORED%", (OfflinePlayer)sender));
                                break;
                            }
                            sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                            break;
                        }
                        sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                        break;
                    }
                    case "set": {
                        if (!sender.hasPermission("xpbank.admin")) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.NO_PERM_MESSAGE));
                            break;
                        }
                        int amount = this.getAmount(args[2], sender);
                        if (amount == -1) break;
                        if (amount > Main.MAX_XP_STORED) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT_TARGET));
                            break;
                        }
                        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)args[1]);
                        if (offline == null) {
                            sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                        }
                        if (Main.xps.containsKey(offline.getUniqueId().toString())) {
                            Main.xps.put(offline.getUniqueId().toString(), amount);
                            if (Main.instance.getConfig().getBoolean("notify-on-admin-balance-change") && offline.isOnline()) {
                                Player online = offline.getPlayer();
                                online.sendMessage(ChatColor.YELLOW + "Your balance has been set to " + amount + " by an admin");
                            }
                            sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + offline.getName() + "'s balance is now " + "%XP_STORED%", offline));
                            break;
                        }
                        if (offline.isOnline()) {
                            Main.xps.put(offline.getUniqueId().toString(), amount);
                            Player online = offline.getPlayer();
                            if (Main.instance.getConfig().getBoolean("notify-on-admin-balance-change")) {
                                online.sendMessage(ChatColor.YELLOW + "Your balance has been set to " + amount + " by an admin");
                            }
                            sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + offline.getName() + "'s balance is now " + "%XP_STORED%", offline));
                            break;
                        }
                        sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                        break;
                    }
                    case "add": {
                        if (!sender.hasPermission("xpbank.admin")) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.NO_PERM_MESSAGE));
                            break;
                        }
                        int amount = this.getAmount(args[2], sender);
                        if (amount == -1) break;
                        if (amount > Main.MAX_XP_STORED) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.EXCEEDS_STORE_LIMIT_TARGET));
                            break;
                        }
                        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)args[1]);
                        if (offline == null) {
                            sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                        }
                        if (Main.xps.containsKey(offline.getUniqueId().toString())) {
                            Main.xps.put(offline.getUniqueId().toString(), amount + Main.xps.get(offline.getUniqueId().toString()));
                            if (Main.instance.getConfig().getBoolean("notify-on-admin-balance-change") && offline.isOnline()) {
                                Player online = offline.getPlayer();
                                online.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + "Your xp balance has been set to " + "%XP_STORED%" + " by an admin", (OfflinePlayer)online));
                            }
                            sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + offline.getName() + "'s balance is now " + "%XP_STORED%", offline));
                            break;
                        }
                        if (offline.isOnline()) {
                            Main.xps.put(offline.getUniqueId().toString(), amount);
                            Player online = offline.getPlayer();
                            if (Main.instance.getConfig().getBoolean("notify-on-admin-balance-change")) {
                                online.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + "Your balance has been set to " + "%XP_STORED%" + " by an admin", (OfflinePlayer)online));
                            }
                            sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + offline.getName() + "'s balance is now " + "%XP_STORED%", offline));
                            break;
                        }
                        sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                        break;
                    }
                    case "remove": {
                        if (!sender.hasPermission("xpbank.admin")) {
                            sender.sendMessage(Utils.replacePlaceholders(Main.NO_PERM_MESSAGE));
                            break;
                        }
                        int amount = this.getAmount(args[2], sender);
                        if (amount == -1) break;
                        OfflinePlayer offline = Bukkit.getOfflinePlayer((String)args[1]);
                        if (offline == null) {
                            sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                        }
                        if (!Main.xps.containsKey(offline.getUniqueId().toString())) {
                            if (offline.isOnline()) {
                                Main.xps.put(offline.getUniqueId().toString(), 0);
                                Player online = offline.getPlayer();
                                if (Main.instance.getConfig().getBoolean("notify-on-admin-balance-change")) {
                                    online.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + "Your balance has been set to " + "%XP_STORED%" + " by an admin", (OfflinePlayer)online));
                                }
                                sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + offline.getName() + "'s balance is now " + "%XP_STORED%", offline));
                                break;
                            }
                            sender.sendMessage(Utils.replacePlaceholders(PLAYER_NOT_FOUND_MESSAGE));
                            break;
                        }
                        if (Main.xps.get(offline.getUniqueId().toString()) - amount < 0) {
                            amount = Main.xps.get(offline.getUniqueId().toString());
                        }
                        Main.xps.put(offline.getUniqueId().toString(), Main.xps.get(offline.getUniqueId().toString()) - amount);
                        if (Main.instance.getConfig().getBoolean("notify-on-admin-balance-change") && offline.isOnline()) {
                            Player online = offline.getPlayer();
                            online.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + "Your balance has been set to " + "%XP_STORED%" + " by an admin", (OfflinePlayer)online));
                        }
                        sender.sendMessage(Utils.replacePlaceholders(ChatColor.YELLOW + offline.getName() + "'s balance is now " + "%XP_STORED%", offline));
                        break;
                    }
                    default: {
                        sender.sendMessage(Utils.replacePlaceholders(String.valueOf(Main.IMPROPER_USE_MESSAGE) + "/xpbank <deposit/withdraw> <amount>"));
                        break;
                    }
                }
                break;
            }
            default: {
                sender.sendMessage(Utils.replacePlaceholders(String.valueOf(Main.IMPROPER_USE_MESSAGE) + "/xpbank help for help"));
            }
        }
    }

    private int getAmount(String string, Player p) {
        try {
            int toReturn = Integer.parseInt(string);
            if (toReturn > 0) {
                return toReturn;
            }
            p.sendMessage(ChatColor.RED + "Invalid amount (Must be greater than zero)");
            return -1;
        }
        catch (NumberFormatException e) {
            p.sendMessage(ChatColor.RED + "Invalid amount");
            return -1;
        }
    }

    private void checkBalInstance(OfflinePlayer p) {
        if (!Main.xps.containsKey(p.getUniqueId().toString())) {
            Main.xps.put(p.getUniqueId().toString(), 0);
        }
    }

    private void asConsole(CommandSender sender, String[] args) {
    }

    private void addXp(int xp, Player p) {
        int newLevel;
        int newTotal = Utils.totalXp(p) + xp;
        float newXp = Utils.xp(newTotal, newLevel = Utils.level(newTotal));
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }

    private void removeXp(int xp, Player p) {
        int newLevel;
        int newTotal = Utils.totalXp(p) - xp;
        float newXp = Utils.xp(newTotal, newLevel = Utils.level(newTotal));
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }

    private void addLevels(int levels, Player p) {
        int newLevel;
        int xpToAdd = Utils.totalXp(p.getLevel() + levels) - Utils.totalXp(p.getLevel());
        int newTotal = Utils.totalXp(p) + xpToAdd;
        float newXp = Utils.xp(newTotal, newLevel = Utils.level(newTotal));
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }

    private void removeLevels(int levels, Player p) {
        int newLevel;
        int xpToLose = Utils.totalXp(p.getLevel()) - Utils.totalXp(p.getLevel() - levels);
        int newTotal = Utils.totalXp(p) - xpToLose;
        float newXp = Utils.xp(newTotal, newLevel = Utils.level(newTotal));
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }

    private void addXp(int xp, Player p, int playerTotalXp) {
        int newTotal = playerTotalXp + xp;
        int newLevel = Utils.level(newTotal);
        float newXp = Utils.xp(newTotal, newLevel);
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }

    private void removeXp(int xp, Player p, int playerTotalXp) {
        int newTotal = playerTotalXp - xp;
        int newLevel = Utils.level(newTotal);
        float newXp = Utils.xp(newTotal, newLevel);
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }

    private void addLevels(int levels, Player p, int playerTotalXp) {
        int newLevel;
        int xpToAdd = Utils.totalXp(p.getLevel() + levels) - Utils.totalXp(p.getLevel());
        int newTotal = Utils.totalXp(p) + xpToAdd;
        float newXp = Utils.xp(newTotal, newLevel = Utils.level(newTotal));
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }

    private void removeLevels(int levels, Player p, int playerTotalXp) {
        int newLevel;
        int xpToLose = Utils.totalXp(p.getLevel()) - Utils.totalXp(p.getLevel() - levels);
        int newTotal = playerTotalXp - xpToLose;
        float newXp = Utils.xp(newTotal, newLevel = Utils.level(newTotal));
        if (newXp == 1.0f) {
            ++newLevel;
            newXp = 0.0f;
        }
        p.setLevel(newLevel);
        p.setExp(newXp);
    }
}

