/*
 * Decompiled with CFR 0.152.
 */
package fr.keke142.worldupdater.providers;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import fr.keke142.worldupdater.RegionProvider;
import fr.keke142.worldupdater.ResolvingRegionsException;
import fr.keke142.worldupdater.UpdaterRegion;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WorldGuardRegionProvider
implements RegionProvider {
    private WorldGuard worldGuard;

    public WorldGuardRegionProvider(WorldGuard worldGuard) {
        this.worldGuard = worldGuard;
    }

    @Override
    public Set<UpdaterRegion> getWorldRegions(org.bukkit.World world) throws ResolvingRegionsException {
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        RegionContainer container = this.worldGuard.getPlatform().getRegionContainer();
        RegionManager regionManager = container.get(weWorld);
        if (regionManager == null) {
            throw new ResolvingRegionsException();
        }
        Map regions = regionManager.getRegions();
        HashSet<UpdaterRegion> updaterRegions = new HashSet<UpdaterRegion>();
        regions.forEach((id, region) -> updaterRegions.add(new UpdaterRegion(region.getMinimumPoint(), region.getMaximumPoint())));
        return updaterRegions;
    }
}

