/*
 * Decompiled with CFR 0.152.
 */
package fr.keke142.worldupdater.providers;

import com.sk89q.worldedit.math.BlockVector3;
import fr.keke142.worldupdater.RegionProvider;
import fr.keke142.worldupdater.ResolvingRegionsException;
import fr.keke142.worldupdater.UpdaterRegion;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.World;

public class GriefPreventionRegionProvider
implements RegionProvider {
    private GriefPrevention griefPrevention;

    public GriefPreventionRegionProvider(GriefPrevention griefPrevention) {
        this.griefPrevention = griefPrevention;
    }

    @Override
    public Set<UpdaterRegion> getWorldRegions(World world) throws ResolvingRegionsException {
        DataStore dataStore = this.griefPrevention.dataStore;
        try {
            Field fld = DataStore.class.getDeclaredField("claims");
            fld.setAccessible(true);
            Object o = fld.get(dataStore);
            ArrayList claims = (ArrayList)o;
            HashSet<UpdaterRegion> updaterRegions = new HashSet<UpdaterRegion>();
            claims.forEach(claim -> {
                Location lesserCorner = claim.getLesserBoundaryCorner();
                BlockVector3 lesserCornerVector = BlockVector3.at((double)lesserCorner.getX(), (double)lesserCorner.getY(), (double)lesserCorner.getZ());
                Location greaterCorner = claim.getGreaterBoundaryCorner();
                BlockVector3 greaterCornerVector = BlockVector3.at((double)greaterCorner.getX(), (double)greaterCorner.getY(), (double)greaterCorner.getZ());
                updaterRegions.add(new UpdaterRegion(lesserCornerVector, greaterCornerVector));
            });
            return updaterRegions;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new ResolvingRegionsException(e);
        }
    }
}

