/*
 * Decompiled with CFR 0.152.
 */
package fr.keke142.worldupdater;

import com.boydti.fawe.jnbt.anvil.MCAFile;
import com.boydti.fawe.jnbt.anvil.MCAFilter;
import com.boydti.fawe.jnbt.anvil.MCAQueue;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import fr.keke142.worldupdater.RegionProvider;
import fr.keke142.worldupdater.ResolvingRegionsException;
import fr.keke142.worldupdater.UpdaterRegion;
import fr.keke142.worldupdater.WorldUpdaterPlugin;
import fr.keke142.worldupdater.providers.GriefPreventionRegionProvider;
import fr.keke142.worldupdater.providers.WorldGuardRegionProvider;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.PluginManager;

public class ConvertMyWorldCommand
implements CommandExecutor {
    private static final int REGION_SHIFTS = 5;
    private static final int CHUNK_SHIFTS = 4;
    private static final int WORLD_MIN_Y = 0;
    private static final int WORLD_MAX_Y = 256;
    private WorldUpdaterPlugin plugin;
    private Set<BlockVector2> blacklistedRegions = new HashSet<BlockVector2>();
    private Set<BlockVector2> blacklistedChunks = new HashSet<BlockVector2>();

    public ConvertMyWorldCommand(WorldUpdaterPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(ChatColor.RED + "Please provide a world name !");
            return false;
        }
        String worldName = args[0];
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            sender.sendMessage(ChatColor.RED + "This world not exists !");
            return false;
        }
        HashSet<RegionProvider> regionProviders = new HashSet<RegionProvider>();
        PluginManager pluginManager = this.plugin.getPluginManager();
        final ConsoleCommandSender consoleSender = this.plugin.getServer().getConsoleSender();
        if (pluginManager.isPluginEnabled("WorldGuard")) {
            regionProviders.add(new WorldGuardRegionProvider(WorldGuard.getInstance()));
            consoleSender.sendMessage(ChatColor.GREEN + "Added WorldGuard as region provider.");
        }
        if (pluginManager.isPluginEnabled("GriefPrevention")) {
            regionProviders.add(new GriefPreventionRegionProvider(GriefPrevention.instance));
            consoleSender.sendMessage(ChatColor.GREEN + "Added GriefPrevention as region provider.");
        }
        if (regionProviders.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "Unable to find any region provider !");
            return false;
        }
        HashSet<UpdaterRegion> regions = new HashSet<UpdaterRegion>();
        sender.sendMessage(ChatColor.YELLOW + "Merging providers together...");
        for (RegionProvider provider : regionProviders) {
            try {
                regions.addAll(provider.getWorldRegions(world));
            }
            catch (ResolvingRegionsException e) {
                sender.sendMessage(ChatColor.RED + "Error during resolving world regions: " + e.getCause());
                e.printStackTrace();
            }
        }
        regions.forEach(region -> {
            BlockVector3 min = region.getMinimumPoint().withY(0);
            BlockVector3 max = region.getMaximumPoint().withY(256);
            for (int x = min.getBlockX() >> 4; x <= max.getBlockX() >> 4; ++x) {
                for (int z = min.getBlockZ() >> 4; z <= max.getBlockZ() >> 4; ++z) {
                    this.blacklistedChunks.add(BlockVector2.at((int)x, (int)z));
                }
            }
            this.blacklistedChunks.forEach(chunk -> {
                int chunkX = chunk.getX();
                int chunkZ = chunk.getZ();
                int regionX = chunkX >> 5;
                int regionZ = chunkZ >> 5;
                this.blacklistedRegions.add(BlockVector2.at((int)regionX, (int)regionZ));
            });
        });
        File regionRoot = new File(worldName + File.separator + "region");
        MCAQueue queue = new MCAQueue(worldName, regionRoot, true);
        final MCAFile[] lastRegionFile = new MCAFile[1];
        consoleSender.sendMessage(ChatColor.YELLOW + "Deleting all chunks that are not touch region using FastAsyncWorldEdit FaweQueue...");
        Bukkit.getOnlinePlayers().forEach(player -> player.kickPlayer(ChatColor.YELLOW + "Starting world conversion, please check your console !"));
        consoleSender.sendMessage(ChatColor.YELLOW + "Unloading all chunks of the world...");
        for (Chunk loadedChunk : world.getLoadedChunks()) {
            loadedChunk.unload();
        }
        queue.filterWorld(new MCAFilter(){

            public MCAFile applyFile(MCAFile mca) {
                int mcaX = mca.getX();
                int mcaZ = mca.getZ();
                BlockVector2 mcaVector = BlockVector2.at((int)mcaX, (int)mcaZ);
                for (BlockVector2 region : ConvertMyWorldCommand.this.blacklistedRegions) {
                    if (!mcaVector.equals((Object)region)) continue;
                    lastRegionFile[0] = mca;
                    return mca;
                }
                mca.close(ForkJoinPool.commonPool());
                mca.getFile().delete();
                consoleSender.sendMessage(ChatColor.YELLOW + "Deleted region (" + mcaX + ";" + mcaZ + ")");
                return null;
            }

            public boolean appliesChunk(int cx, int cz) {
                if (!ConvertMyWorldCommand.this.blacklistedChunks.contains(BlockVector2.at((int)cx, (int)cz))) {
                    try {
                        MCAFile mcaFile = lastRegionFile[0];
                        RandomAccessFile unChunk = new RandomAccessFile(mcaFile.getFile(), "rwd");
                        int offsetX = mcaFile.getX() << 5;
                        int offsetZ = mcaFile.getZ() << 5;
                        long wipePos = 4 * (cx - offsetX + (cz - offsetZ) * 32);
                        unChunk.seek(wipePos);
                        unChunk.writeInt(0);
                        unChunk.close();
                        consoleSender.sendMessage(ChatColor.YELLOW + "Deleted chunk (" + cx + ";" + cz + ")");
                    }
                    catch (IOException e) {
                        ConvertMyWorldCommand.this.plugin.getLogger().severe(ChatColor.RED + "Error deleting chunk (" + cx + ";" + cz + ")");
                        e.printStackTrace();
                    }
                }
                return false;
            }
        });
        consoleSender.sendMessage(ChatColor.GREEN + "Conversion task finished ! Stopping the server to apply changes...");
        Bukkit.shutdown();
        return true;
    }
}

