/*
 * Decompiled with CFR 0.152.
 */
package me.RaulH22.RandomTp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.RaulH22.RandomTp.Main;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigFile {
    private Main pl = (Main)Main.getPlugin(Main.class);
    private String filePath;
    private File file;
    private FileConfiguration config;

    public ConfigFile(String path, boolean createIfNeeds, boolean isDefault, boolean notify) {
        this.filePath = path;
        this.file = this.loadFile(createIfNeeds, notify);
        this.config = this.loadConfig(isDefault);
    }

    public ConfigFile(String path, boolean createIfNeeds, boolean isDefault) {
        this.filePath = path;
        this.file = this.loadFile(createIfNeeds);
        this.config = this.loadConfig(isDefault);
    }

    public ConfigFile(String path, boolean createIfNeeds) {
        this.filePath = path;
        this.file = this.loadFile(createIfNeeds);
        this.config = this.loadConfig(false);
    }

    public ConfigFile(String path) {
        this.filePath = path;
        this.file = this.loadFile(false);
        this.config = this.loadConfig(false);
    }

    private void fix(String path) {
        File oldConfig = new File(this.pl.getDataFolder(), "old" + this.filePath);
        try {
            this.config.save(oldConfig);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File defaultConfig = new File(this.pl.getDataFolder(), this.filePath);
        defaultConfig.getParentFile().mkdirs();
        try {
            this.pl.saveResource(this.filePath, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in \u00a7e" + this.filePath);
        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cthe file has been setted to default!!");
    }

    public File loadFile(boolean createIfNeeds) {
        this.file = new File(this.pl.getDataFolder(), this.filePath);
        if (createIfNeeds && !this.file.exists()) {
            this.file = new File(this.pl.getDataFolder(), this.filePath);
            this.file.getParentFile().mkdirs();
            try {
                this.pl.saveResource(this.filePath, false);
            }
            catch (Exception e) {
                try {
                    this.file.createNewFile();
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a77- New file: \"\u00a7b" + this.filePath + "\u00a77\" successful created!!");
                }
                catch (IOException e1) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7c- Error trying to CREATE: \u00a7e" + this.filePath + "\u00a7c!!!");
                }
            }
        }
        return this.file;
    }

    public File loadFile(boolean createIfNeeds, boolean notify) {
        this.file = new File(this.pl.getDataFolder(), this.filePath);
        if (createIfNeeds && !this.file.exists()) {
            this.file = new File(this.pl.getDataFolder(), this.filePath);
            this.file.getParentFile().mkdirs();
            try {
                this.pl.saveResource(this.filePath, false);
            }
            catch (Exception e) {
                try {
                    this.file.createNewFile();
                    if (notify) {
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a77- New file: \"\u00a7b" + this.filePath + "\u00a77\" successful created!!");
                    }
                }
                catch (IOException e1) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7c- Error trying to CREATE: \u00a7e" + this.filePath + "\u00a7c!!!");
                }
            }
        }
        return this.file;
    }

    public FileConfiguration loadConfig(boolean notify) {
        block3: {
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
            try {
                this.config.load(this.file);
                if (notify) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a77- File \"\u00a7b" + this.filePath + "\u00a77\" loaded!");
                }
            }
            catch (Exception e) {
                if (!notify) break block3;
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7c- Error trying to LOAD: \"\u00a7e" + this.filePath + "\u00a7c\"!!!");
            }
        }
        return this.config;
    }

    public FileConfiguration getGeneralConfig() {
        return this.config;
    }

    public String getPath() {
        return this.filePath;
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getString(String path) {
        if (this.config.get(path) == null) {
            this.fix(path);
        }
        String string = this.config.getString(path);
        return string;
    }

    public String getString(String path, String ifNull) {
        String string;
        try {
            string = this.config.getString(path);
        }
        catch (Exception e) {
            string = ifNull;
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
        }
        return string;
    }

    public int getInt(String path) {
        if (this.config.get(path) == null) {
            this.fix(path);
        }
        int i = this.config.getInt(path);
        return i;
    }

    public int getInt(String path, int ifNull) {
        int i;
        try {
            i = this.config.getInt(path);
        }
        catch (Exception e) {
            i = ifNull;
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
        }
        return i;
    }

    public double getDouble(String path) {
        if (this.config.get(path) == null) {
            this.fix(path);
        }
        double d = this.config.getInt(path);
        return d;
    }

    public double getDouble(String path, double ifNull) {
        double i;
        try {
            i = this.config.getInt(path);
        }
        catch (Exception e) {
            i = ifNull;
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
        }
        return i;
    }

    public long getLong(String path) {
        if (this.config.get(path) == null) {
            this.fix(path);
        }
        long l = this.config.getLong(path);
        return l;
    }

    public boolean getBoolean(String path) {
        if (this.config.get(path) == null) {
            this.fix(path);
        }
        boolean b = this.config.getBoolean(path);
        return b;
    }

    public boolean getBoolean(String path, boolean ifNull) {
        boolean i;
        try {
            i = this.config.getBoolean(path);
        }
        catch (Exception e) {
            i = ifNull;
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
        }
        return i;
    }

    public Object get(String path) {
        if (this.config.get(path) == null) {
            this.fix(path);
        }
        Object o = this.config.get(path);
        return o;
    }

    public Object get(String path, Object ifNull) {
        Object i = null;
        try {
            i = this.config.get(path);
        }
        catch (Exception e) {
            i = ifNull;
        }
        return i;
    }

    public Object get(String path, boolean notify) {
        Object i;
        block2: {
            i = null;
            try {
                i = this.config.get(path);
            }
            catch (Exception e) {
                if (!notify) break block2;
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
            }
        }
        return i;
    }

    public Object get(String path, boolean notify, Object ifNull) {
        Object i;
        try {
            i = this.config.get(path);
        }
        catch (Exception e) {
            if (notify) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
            }
            i = ifNull;
        }
        return i;
    }

    public List<String> getListString(String path) {
        if (this.config.get(path) == null) {
            this.fix(path);
        }
        ArrayList<String> i = new ArrayList<String>();
        try {
            List configList = this.config.getList(path);
            for (Object o : configList) {
                i.add(o.toString());
            }
        }
        catch (Exception e) {
            i = null;
        }
        return i;
    }

    public Object getNode(String path) {
        Collection i = new ArrayList();
        try {
            i = this.config.getConfigurationSection(path).getKeys(false);
        }
        catch (Exception e) {
            i = null;
        }
        return i;
    }

    public Object getNode(String path, Object ifNull) {
        Object i = new ArrayList();
        try {
            i = this.config.getConfigurationSection(path).getKeys(false);
        }
        catch (Exception e) {
            i = ifNull;
        }
        return i;
    }

    public ArrayList<String> getNodeList(String path) {
        ArrayList<String> i = new ArrayList<String>();
        try {
            for (String string : this.config.getConfigurationSection(path).getKeys(false)) {
                i.add(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public ArrayList<String> getNodeList(String path, boolean notify) {
        ArrayList<String> i;
        block3: {
            i = new ArrayList<String>();
            try {
                for (String string : this.config.getConfigurationSection(path).getKeys(false)) {
                    i.add(string);
                }
            }
            catch (Exception e) {
                if (!notify) break block3;
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
            }
        }
        return i;
    }

    public void setNode(String path, String node, Object value) {
        try {
            this.config.getConfigurationSection(path).set(node, value);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
        }
    }

    public void set(String path, Object obj) {
        try {
            this.config.set(path, obj);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7cError trying to get \u00a7e" + path + "\u00a7c in a config file!!!");
        }
    }

    public void saveConfig(boolean notify) {
        try {
            this.config.save(this.file);
            if (notify) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a77- File \"\u00a7b" + this.filePath + "\u00a77\" saved!");
            }
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7c- Error trying to SAVE: \"\u00a7e" + this.filePath + "\u00a7c\"!!!");
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.pl.prefix) + "\u00a7c- Error trying to SAVE: \"\u00a7e" + this.filePath + "\u00a7c\"!!!");
        }
    }
}

