/*
 * Decompiled with CFR 0.152.
 */
package com.eickmung.worldprotection.config;

import com.eickmung.worldprotection.Main;
import com.eickmung.worldprotection.utility.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseConfig {
    private final JavaPlugin plugin;
    private final File file;
    private final FileConfiguration config;
    private final String configName;

    public BaseConfig(JavaPlugin plugin, String name) {
        this.configName = name;
        this.plugin = plugin;
        FileUtils.checkDirectory(plugin.getDataFolder());
        this.file = new File(plugin.getDataFolder(), this.configName);
        FileUtils.checkFile(this.file);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.config.options().copyDefaults(true);
        this.config.options().copyHeader(true);
        this.config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new BufferedReader(new InputStreamReader(Main.getInstance().getResource(this.configName)))));
        this.save();
    }

    public abstract void load();

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getConfigName() {
        return this.configName;
    }
}

