/*
 * Decompiled with CFR 0.152.
 */
package com.eickmung.worldprotection;

import com.eickmung.worldprotection.config.impl.WorldConfig;
import com.eickmung.worldprotection.listeners.PlayerListener;
import org.bukkit.ChatColor;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main instance;
    private static WorldConfig worldConfig;
    private static final String PREFIX;

    static {
        PREFIX = ChatColor.DARK_GRAY + "[" + ChatColor.RED + "WorldProtection" + ChatColor.DARK_GRAY + "]" + ChatColor.RESET;
    }

    public void onEnable() {
        instance = this;
        long startTime = System.currentTimeMillis();
        worldConfig = new WorldConfig(this);
        worldConfig.load();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        Main.log(LOG_LEVEL.INFO, "The plugin has been activated (" + (double)(System.currentTimeMillis() - startTime) / 1000.0 + "s)");
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public static void log(LOG_LEVEL level, String text) {
        Main.getInstance().getServer().getConsoleSender().sendMessage(ChatColor.DARK_GRAY + "[" + level.getName() + ChatColor.DARK_GRAY + "] " + ChatColor.RESET + text);
    }

    public static Main getInstance() {
        return instance;
    }

    public static WorldConfig getWorldConfig() {
        return worldConfig;
    }

    public static String getPREFIX() {
        return PREFIX;
    }

    public static enum LOG_LEVEL {
        INFO("INFO", 0, ChatColor.GREEN + "INFO"),
        WARNING("WARNING", 1, ChatColor.YELLOW + "WARNING"),
        ERROR("ERROR", 2, ChatColor.RED + "ERROR");

        private final String name;

        private LOG_LEVEL(String s, int n2, String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

