/*
 * Decompiled with CFR 0.152.
 */
package us.updat.worldpluginmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import us.updat.worldpluginmanager.CleanReloadRunnable;
import us.updat.worldpluginmanager.WorldPluginManager;

public class SetPluginCommand
implements CommandExecutor {
    WorldPluginManager pl;

    public SetPluginCommand(WorldPluginManager instance) {
        this.pl = instance;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (sender instanceof Player && ((player = (Player)sender).isOp() || player.hasPermission("worldpm.*") || player.hasPermission("worldpm.execute")) && args != null) {
            ConfigurationSection originalValue;
            boolean worldIsReal;
            if (args.length == 0) {
                String helpMessage = ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "WorldPluginManager - Created by Max Bridgland \n" + "============================================= \n" + ChatColor.GREEN + ChatColor.BOLD + "/wpm " + ChatColor.RESET + "- Display This Information.\n \n" + ChatColor.GREEN + ChatColor.BOLD + "/wpm list " + ChatColor.RESET + "- List Plugins Loaded and Configured.\n \n" + ChatColor.GREEN + ChatColor.BOLD + "/wpm get plugin [world] " + ChatColor.RESET + "- See Configuration for Plugin. World specifies a world name.\n \n" + ChatColor.GREEN + ChatColor.BOLD + "/wpm enable/disable plugin [world] " + ChatColor.RESET + "- Allow/Disallow a Plugin's Usage. World specifies a world name.\n \n" + ChatColor.GREEN + ChatColor.BOLD + "/wpm reload " + ChatColor.RESET + "- Reload Configuration from Config.yml.\n \n" + ChatColor.GREEN + ChatColor.BOLD + "/wpm clean_reload " + ChatColor.RED + ChatColor.BOLD + "- WARNING EXPERIMENTAL!" + ChatColor.RESET + " Queue or Confirm a Clean Reload of Plugins.\n \n" + ChatColor.GREEN + ChatColor.BOLD + "/wpm clear_reload " + ChatColor.RESET + "- Clear Clean Reloader Queue. \n \n";
                player.sendMessage(helpMessage);
                return true;
            }
            if (args[0].equalsIgnoreCase("list") && (player.hasPermission("worldpm.read") || player.hasPermission("worldpm.*"))) {
                String result = ChatColor.GOLD + "[WPM] Available Plugins: ";
                boolean changed = false;
                Plugin[] pluginArray = Bukkit.getServer().getPluginManager().getPlugins();
                int n = pluginArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Map commands;
                    Plugin plugin = pluginArray[n2];
                    if (plugin.getDescription() != null && plugin.getDescription().getCommands() != null && (commands = plugin.getDescription().getCommands()) != null) {
                        result = String.valueOf(result) + plugin.getName() + ", ";
                        changed = true;
                    }
                    ++n2;
                }
                if (changed) {
                    result = result.substring(0, result.length() - 2);
                    player.sendMessage(result);
                    return true;
                }
                player.sendMessage(String.valueOf(result) + "None! Something might be broken...");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload") && (player.hasPermission("worldpm.write") || player.hasPermission("worldpm.*") || player.isOp())) {
                this.pl.reloadConfiguration(player);
                player.sendMessage(ChatColor.GREEN + "[WPM] Reload Complete");
                return true;
            }
            if (args[0].equalsIgnoreCase("clear_reload") && (player.hasPermission("worldpm.write") || player.hasPermission("worldpm.*") || player.isOp())) {
                if (this.pl.cleanReloadQueue.size() < 1) {
                    player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WMP Clean Reloader]" + ChatColor.RESET + ChatColor.RED + "There is no reload queued!");
                    return true;
                }
                this.pl.cleanReloadQueue = new HashMap();
                player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WMP Clean Reloader]" + ChatColor.RESET + ChatColor.GREEN + "Cleared reload queue!");
                return true;
            }
            if (args[0].equalsIgnoreCase("clean_reload") && (player.hasPermission("worldpm.write") || player.hasPermission("worldpm.*") || player.isOp())) {
                if (this.pl.cleanReloadQueue.size() >= 1) {
                    if (this.pl.cleanReloadQueue.containsKey(player.getUniqueId().toString())) {
                        for (String pluginQ : this.pl.cleanReloadQueue.get(player.getUniqueId().toString())) {
                            this.pl.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.pl, (Runnable)new CleanReloadRunnable(pluginQ), 10L);
                        }
                        this.pl.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.pl, new Runnable(){

                            @Override
                            public void run() {
                                player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WMP Clean Reloader] " + ChatColor.RESET + ChatColor.GREEN + "Reload Initiated and Call Complete!");
                            }
                        });
                        return true;
                    }
                    player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WMP Clean Reloader]" + ChatColor.RESET + ChatColor.RED + "There is a reload queued already! Use /wmp clearreload to reset the queue!");
                    return true;
                }
                ArrayList<String> dontReload = new ArrayList<String>(Arrays.asList("ProtocolLib", "LagAssist", "DiscordSRV", "ViaVersion", "ViaBackwards", "Votifier", "ProtocolSupport", "PlaceholderAPI", "WorldPluginManager", "dynmap"));
                ArrayList<String> pluginsToReload = new ArrayList<String>();
                Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
                int n = pluginArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Map pCmds;
                    Plugin bukkitPlugin = pluginArray[n3];
                    if (!dontReload.contains(bukkitPlugin.getName()) && (pCmds = bukkitPlugin.getDescription().getCommands()) != null) {
                        pluginsToReload.add(bukkitPlugin.getName());
                    }
                    ++n3;
                }
                this.pl.cleanReloadQueue.put(player.getUniqueId().toString(), pluginsToReload);
                player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WMP Clean Reloader]" + ChatColor.RESET + ChatColor.RED + "WARNING!!! This is an extremely experiemental feature. Please type the command again to run the clean reloader.");
                String toSend = ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WMP Clean Reloader]" + " Queued Plugins For Reload: " + ChatColor.RESET;
                for (String plug : pluginsToReload) {
                    toSend = String.valueOf(toSend) + plug + ", ";
                }
                player.sendMessage(toSend.substring(0, toSend.length() - 2));
                return true;
            }
            if (args[0].equalsIgnoreCase("get") && (player.hasPermission("worldpm.read") || player.hasPermission("worldpm.*") || player.isOp())) {
                if (args.length == 2) {
                    String state = "";
                    Plugin[] pluginArray = Bukkit.getServer().getPluginManager().getPlugins();
                    int plug = pluginArray.length;
                    int n = 0;
                    while (n < plug) {
                        Plugin plugin = pluginArray[n];
                        for (World world : Bukkit.getServer().getWorlds()) {
                            Map commands;
                            if (plugin.getDescription() == null || plugin.getDescription().getCommands() == null || (commands = plugin.getDescription().getCommands()) == null || !args[1].equalsIgnoreCase(plugin.getName())) continue;
                            state = this.pl.getConfig().getBoolean("worlds." + world.getName() + ".plugins." + plugin.getName()) ? String.valueOf(state) + "\n" + ChatColor.BOLD + ChatColor.GREEN + "Allowed " + ChatColor.RESET + "in world: " + world.getName() : String.valueOf(state) + "\n" + ChatColor.BOLD + ChatColor.RED + "Disallowed " + ChatColor.RESET + "in world: " + world.getName();
                        }
                        ++n;
                    }
                    if (state != "") {
                        player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WPM] Plugin State For: " + ChatColor.RESET + args[1] + state);
                        return true;
                    }
                    player.sendMessage(ChatColor.BOLD + ChatColor.RED + "[WPM] ERROR: " + ChatColor.RESET + ChatColor.RED + "Plugin: " + args[1] + ", could not be found!");
                    return true;
                }
                if (args.length == 3) {
                    String state = "";
                    Plugin[] pluginArray = Bukkit.getServer().getPluginManager().getPlugins();
                    int plug = pluginArray.length;
                    int n = 0;
                    while (n < plug) {
                        World targetWorld;
                        Map commands;
                        Plugin plugin = pluginArray[n];
                        if (plugin.getDescription() != null && plugin.getDescription().getCommands() != null && (commands = plugin.getDescription().getCommands()) != null && plugin.getName().contains(args[1].toString().trim()) && (targetWorld = Bukkit.getWorld((String)args[2])) != null && targetWorld.getName().equalsIgnoreCase(args[2])) {
                            boolean plState = this.pl.getConfig().getBoolean("worlds." + args[2] + ".plugins." + plugin.getName());
                            state = plState ? String.valueOf(state) + "\n" + ChatColor.BOLD + ChatColor.GREEN + "Allowed " + ChatColor.RESET + "in world: " + args[2] : String.valueOf(state) + "\n" + ChatColor.BOLD + ChatColor.RED + "Disallowed " + ChatColor.RESET + "in world: " + args[2];
                        }
                        ++n;
                    }
                    if (state != "") {
                        player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WPM] Plugin State For: " + ChatColor.RESET + args[1] + state);
                        return true;
                    }
                    player.sendMessage(ChatColor.BOLD + ChatColor.RED + "[WPM] ERROR: " + ChatColor.RESET + ChatColor.RED + "World or Plugin could not be found!");
                    return true;
                }
                player.sendMessage(ChatColor.BOLD + ChatColor.RED + "[WPM] ERROR: " + ChatColor.RESET + ChatColor.RED + "Incorrect amount of arguments! Usage: /wpm get plugin [world_name]");
                return true;
            }
            if (args[0].equalsIgnoreCase("enable") && args.length != 2 && args.length != 3 || !player.hasPermission("worldpm.write") && !player.hasPermission("worldpm.*") && !player.isOp()) {
                player.sendMessage(ChatColor.BOLD + ChatColor.RED + "[WPM] ERROR: " + ChatColor.RESET + ChatColor.RED + "Specify a plugin or use /wpm list to see all plugins available!");
                return true;
            }
            if (args[0].equalsIgnoreCase("enable") && args.length == 2 && (player.hasPermission("worldpm.write") || player.hasPermission("worldpm.*") || player.isOp())) {
                boolean setAtLeastOne = false;
                for (World world : Bukkit.getWorlds()) {
                    ConfigurationSection originalValue2 = this.pl.getConfig().getConfigurationSection("worlds." + world.getName() + ".plugins");
                    if (!originalValue2.contains(args[1])) continue;
                    this.pl.getConfig().set("worlds." + world.getName() + ".plugins." + args[1], (Object)true);
                    this.pl.saveConfig();
                    setAtLeastOne = true;
                }
                if (setAtLeastOne) {
                    player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WPM] " + ChatColor.RESET + "Set " + args[1] + " to " + args[0] + "d in all worlds.");
                    return true;
                }
                player.sendMessage(ChatColor.BOLD + ChatColor.RED + "[WPM] ERROR: " + ChatColor.RESET + ChatColor.RED + "Plugin could not be found!");
                return true;
            }
            if (args[0].equalsIgnoreCase("disable") && args.length == 2 && (player.hasPermission("worldpm.write") || player.hasPermission("worldpm.*") || player.isOp())) {
                boolean setAtLeastOne = false;
                for (World world : Bukkit.getWorlds()) {
                    ConfigurationSection originalValue3 = this.pl.getConfig().getConfigurationSection("worlds." + world.getName() + ".plugins");
                    if (!originalValue3.contains(args[1])) continue;
                    this.pl.getConfig().set("worlds." + world.getName() + ".plugins." + args[1], (Object)false);
                    this.pl.saveConfig();
                    setAtLeastOne = true;
                }
                if (setAtLeastOne) {
                    player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WPM] " + ChatColor.RESET + "Set " + args[1] + " to " + args[0] + "d in all worlds.");
                    return true;
                }
                player.sendMessage(ChatColor.BOLD + ChatColor.RED + "[WPM] ERROR: " + ChatColor.RESET + ChatColor.RED + "Plugin could not be found!");
                return true;
            }
            if (args[0].equalsIgnoreCase("enable") && args.length == 3 && (player.hasPermission("worldpm.write") || player.hasPermission("worldpm.*") || player.isOp())) {
                worldIsReal = false;
                for (World world : Bukkit.getWorlds()) {
                    if (!world.getName().equalsIgnoreCase(args[2])) continue;
                    worldIsReal = true;
                }
                if (worldIsReal) {
                    originalValue = this.pl.getConfig().getConfigurationSection("worlds." + args[2] + ".plugins");
                    if (originalValue.contains(args[1])) {
                        this.pl.getConfig().set("worlds." + args[2] + ".plugins." + args[1], (Object)true);
                        this.pl.saveConfig();
                    }
                    player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WPM] " + ChatColor.RED + "Allowed " + ChatColor.RESET + args[1] + " in world: " + args[2]);
                    return true;
                }
            }
            if (args[0].equalsIgnoreCase("disable") && args.length == 3 && (player.hasPermission("worldpm.write") || player.hasPermission("worldpm.*") || player.isOp())) {
                worldIsReal = false;
                for (World world : Bukkit.getWorlds()) {
                    if (!world.getName().equalsIgnoreCase(args[2])) continue;
                    worldIsReal = true;
                }
                if (worldIsReal) {
                    originalValue = this.pl.getConfig().getConfigurationSection("worlds." + args[2] + ".plugins");
                    if (originalValue.contains(args[1])) {
                        this.pl.getConfig().set("worlds." + args[2] + ".plugins." + args[1], (Object)false);
                        this.pl.saveConfig();
                    }
                    player.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WPM] " + ChatColor.RED + "Disallowed " + ChatColor.RESET + args[1] + " in world: " + args[2]);
                    return true;
                }
            }
        }
        if (sender instanceof Player) {
            sender.sendMessage(ChatColor.BOLD + ChatColor.LIGHT_PURPLE + "[WPM] " + ChatColor.RED + "Unknown Command or Insufficient Permissions.");
        }
        return true;
    }
}

