/*
 * Decompiled with CFR 0.152.
 */
package mcplugin.shawn_ian.waypoints.user;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import mcplugin.shawn_ian.waypoints.Main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Waypoints {
    public static void addWaypoint(Player player, String name, Location loc) {
        YamlConfiguration data;
        String uuid = player.getUniqueId().toString();
        File file = new File("plugins/Waypoints/userdata/" + uuid + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((data = YamlConfiguration.loadConfiguration((File)file)).contains(name)) {
            player.sendMessage(ChatColor.RED + "You already have a waypoint with this name.");
            return;
        }
        data.set(name, (Object)loc);
        try {
            data.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendMessage(ChatColor.GREEN + "Created a waypoint called " + ChatColor.DARK_GREEN + name + ChatColor.GREEN + "!");
    }

    public static void removeWaypoint(Player player, String name) {
        YamlConfiguration data;
        String uuid = player.getUniqueId().toString();
        File file = new File("plugins/Waypoints/userdata/" + uuid + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(data = YamlConfiguration.loadConfiguration((File)file)).contains(name)) {
            player.sendMessage(ChatColor.RED + "You do not have a waypoint with this name.");
            return;
        }
        data.set(name, null);
        try {
            data.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendMessage(ChatColor.RED + "Removed the waypoint " + ChatColor.DARK_RED + name + ChatColor.RED + "!");
    }

    public static void teleportToWaypoint(final Player player, final String name) {
        String uuid = player.getUniqueId().toString();
        File file = new File("plugins/Waypoints/userdata/" + uuid + ".yml");
        if (!file.exists()) {
            player.sendMessage(ChatColor.RED + "You do not have any waypoints.");
            return;
        }
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
        if (!data.contains(name)) {
            player.sendMessage(ChatColor.RED + "You do not have a waypoint with this name.");
            return;
        }
        int delay = ((Main)Main.getPlugin(Main.class)).getConfig().getInt("delay");
        final Location loc = (Location)data.get(name);
        if (player.hasPermission("waypoints.bypassdelay") || delay == 0) {
            player.sendMessage(ChatColor.YELLOW + "Sending you to your waypoint " + ChatColor.GOLD + name + ChatColor.YELLOW + ".");
            player.teleport(loc);
            return;
        }
        if (delay == 1) {
            player.sendMessage(ChatColor.YELLOW + "Sending you to your waypoint " + ChatColor.GOLD + name + ChatColor.YELLOW + "in " + delay + " second.");
        } else {
            player.sendMessage(ChatColor.YELLOW + "Sending you to your waypoint " + ChatColor.GOLD + name + ChatColor.YELLOW + "in " + delay + " seconds.");
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.getPlugin(Main.class), new Runnable(){

            @Override
            public void run() {
                player.sendMessage(ChatColor.YELLOW + "Sending you to your waypoint " + ChatColor.GOLD + name + ChatColor.YELLOW + ".");
                player.teleport(loc);
            }
        }, (long)(delay * 20));
    }

    public static void moveWaypoint(Player player, String name, Location loc) {
        YamlConfiguration data;
        String uuid = player.getUniqueId().toString();
        File file = new File("plugins/Waypoints/userdata/" + uuid + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(data = YamlConfiguration.loadConfiguration((File)file)).contains(name)) {
            player.sendMessage(ChatColor.RED + "You do not have a waypoint with this name.");
            return;
        }
        data.set(name, (Object)loc);
        try {
            data.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendMessage(ChatColor.GREEN + "Moved the waypoint " + ChatColor.DARK_GREEN + name + ChatColor.GREEN + " to your current location!");
    }

    public static void renameWaypoint(Player player, String name, String newname) {
        YamlConfiguration data;
        String uuid = player.getUniqueId().toString();
        File file = new File("plugins/Waypoints/userdata/" + uuid + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(data = YamlConfiguration.loadConfiguration((File)file)).contains(name)) {
            player.sendMessage(ChatColor.RED + "You do not have a waypoint with this name.");
            return;
        }
        if (data.contains(newname)) {
            player.sendMessage(ChatColor.RED + "You already have a waypoint with this name.");
            return;
        }
        Location loc = (Location)data.get(name);
        data.set(name, null);
        data.set(newname, (Object)loc);
        try {
            data.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendMessage(ChatColor.GREEN + "Renamed the waypoint " + ChatColor.DARK_GREEN + name + ChatColor.GREEN + " to " + ChatColor.DARK_GREEN + newname + ChatColor.GREEN + "!");
    }

    public static void displayWaypointsAsString(Player player) {
        String uuid = player.getUniqueId().toString();
        File file = new File("plugins/Waypoints/userdata/" + uuid + ".yml");
        if (!file.exists()) {
            player.sendMessage(ChatColor.RED + "You do not have any waypoints.");
            return;
        }
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
        Set keys = data.getKeys(false);
        String s = "";
        s = keys.size() == 1 ? ChatColor.YELLOW + "Your waypoint: " + ChatColor.GOLD : ChatColor.YELLOW + "Your waypoints: " + ChatColor.GOLD;
        int i = 0;
        for (String d : keys) {
            s = ++i == keys.size() ? String.valueOf(s) + d + ChatColor.WHITE + "." : String.valueOf(s) + d + ChatColor.WHITE + ", " + ChatColor.GOLD;
        }
        player.sendMessage(s);
    }

    public static void displayWaypointsInfo(Player player, String name) {
        String uuid = player.getUniqueId().toString();
        File file = new File("plugins/Waypoints/userdata/" + uuid + ".yml");
        if (!file.exists()) {
            player.sendMessage(ChatColor.RED + "You do not have any waypoints.");
            return;
        }
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
        if (!data.contains(name)) {
            player.sendMessage(ChatColor.RED + "You do not have a waypoint with this name.");
            return;
        }
        Location loc = (Location)data.get(name);
        player.sendMessage(ChatColor.GOLD + "--------- " + ChatColor.YELLOW.toString() + ChatColor.BOLD + "Info about waypoint: '" + name + "'" + ChatColor.GOLD + " ---------");
        player.sendMessage(ChatColor.YELLOW + "World: " + ChatColor.GOLD + loc.getWorld().getName());
        player.sendMessage(ChatColor.YELLOW + "X: " + ChatColor.GOLD + loc.getX());
        player.sendMessage(ChatColor.YELLOW + "Y: " + ChatColor.GOLD + loc.getY());
        player.sendMessage(ChatColor.YELLOW + "Z: " + ChatColor.GOLD + loc.getZ());
    }
}

