/*
 * Decompiled with CFR 0.152.
 */
package mcplugin.shawn_ian.waypoints.user;

import mcplugin.shawn_ian.waypoints.Main;
import mcplugin.shawn_ian.waypoints.admin.AdminCommand;
import mcplugin.shawn_ian.waypoints.user.Waypoints;
import mkremins.fanciful.FancyMessage;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Command
implements CommandExecutor {
    private Main plugin;

    public Command(Main main) {
        this.plugin = main;
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("waypoints")) {
            if (!(sender instanceof Player)) {
                Bukkit.getLogger().info("You must be a player to use this command.");
                return true;
            }
            Player player = (Player)sender;
            if (args.length < 1) {
                String prefix = ChatColor.YELLOW + "Waypoints " + ChatColor.DARK_GRAY + "// " + ChatColor.GRAY;
                player.sendMessage(String.valueOf(prefix) + "Developer: " + ChatColor.AQUA + "shawn_ian");
                player.sendMessage(String.valueOf(prefix) + "Version: " + ChatColor.GREEN + "1.0");
                player.sendMessage(String.valueOf(prefix) + "Help: " + ChatColor.GOLD + "/wp help");
                return true;
            }
            if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                player.sendMessage(ChatColor.GOLD + "----------- " + ChatColor.YELLOW.toString() + ChatColor.BOLD + "Waypoints Commands" + ChatColor.GOLD + " -----------");
                new FancyMessage(ChatColor.YELLOW + "/wp create <name>").tooltip(ChatColor.GREEN + "Click to run this command!").suggest("/wp create <name>").then(ChatColor.GRAY + " - Create a new waypoint.").send(player);
                new FancyMessage(ChatColor.YELLOW + "/wp remove <name>").tooltip(ChatColor.GREEN + "Click to run this command!").suggest("/wp remove <name>").then(ChatColor.GRAY + " - Remove a waypoint.").send(player);
                new FancyMessage(ChatColor.YELLOW + "/wp teleport <name>").tooltip(ChatColor.GREEN + "Click to run this command!").suggest("/wp teleport <name>").then(ChatColor.GRAY + " - Teleport to a waypoint.").send(player);
                new FancyMessage(ChatColor.YELLOW + "/wp info <name>").tooltip(ChatColor.GREEN + "Click to run this command!").suggest("/wp info <name>").then(ChatColor.GRAY + " - Gives info about the waypoint.").send(player);
                new FancyMessage(ChatColor.YELLOW + "/wp movehere <name>").tooltip(ChatColor.GREEN + "Click to run this command!").suggest("/wp movehere <name>").then(ChatColor.GRAY + " - Move a waypoint to your location.").send(player);
                new FancyMessage(ChatColor.YELLOW + "/wp rename <name> <new name>").tooltip(ChatColor.GREEN + "Click to run this command!").suggest("/wp rename <name> <new name>").then(ChatColor.GRAY + " - Rename a waypoint.").send(player);
                new FancyMessage(ChatColor.YELLOW + "/wp list").tooltip(ChatColor.GREEN + "Click to run this command!").suggest("/wp list").then(ChatColor.GRAY + " - Gives a list of all your waypoints.").send(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("create")) {
                if (!player.hasPermission("waypoints.use.create")) {
                    player.sendMessage(ChatColor.RED + "You do not have permissions to use this command!");
                    return true;
                }
                if (args.length != 2) {
                    player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp help" + ChatColor.RED + " for more help!");
                    return true;
                }
                Waypoints.addWaypoint(player, args[1].toString(), player.getLocation());
                return true;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                if (!player.hasPermission("waypoints.use.remove")) {
                    player.sendMessage(ChatColor.RED + "You do not have permissions to use this command!");
                    return true;
                }
                if (args.length != 2) {
                    player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp help" + ChatColor.RED + " for more help!");
                    return true;
                }
                Waypoints.removeWaypoint(player, args[1].toString());
                return true;
            }
            if (args[0].equalsIgnoreCase("teleport") || args[0].equalsIgnoreCase("tp")) {
                if (!player.hasPermission("waypoints.use.teleport")) {
                    player.sendMessage(ChatColor.RED + "You do not have permissions to use this command!");
                    return true;
                }
                if (args.length != 2) {
                    player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp help" + ChatColor.RED + " for more help!");
                    return true;
                }
                Waypoints.teleportToWaypoint(player, args[1].toString());
                return true;
            }
            if (args[0].equalsIgnoreCase("movehere")) {
                if (!player.hasPermission("waypoints.use.movehere")) {
                    player.sendMessage(ChatColor.RED + "You do not have permissions to use this command!");
                    return true;
                }
                if (args.length != 2) {
                    player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp help" + ChatColor.RED + " for more help!");
                    return true;
                }
                Waypoints.moveWaypoint(player, args[1].toString(), player.getLocation());
                return true;
            }
            if (args[0].equalsIgnoreCase("rename")) {
                if (!player.hasPermission("waypoints.use.rename")) {
                    player.sendMessage(ChatColor.RED + "You do not have permissions to use this command!");
                    return true;
                }
                if (args.length != 3) {
                    player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp help" + ChatColor.RED + " for more help!");
                    return true;
                }
                Waypoints.renameWaypoint(player, args[1].toString(), args[2].toString());
                return true;
            }
            if (args[0].equalsIgnoreCase("list")) {
                if (!player.hasPermission("waypoints.use.list")) {
                    player.sendMessage(ChatColor.RED + "You do not have permissions to use this command!");
                    return true;
                }
                if (args.length != 1) {
                    player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp help" + ChatColor.RED + " for more help!");
                    return true;
                }
                Waypoints.displayWaypointsAsString(player);
                return true;
            }
            if (args[0].equalsIgnoreCase("info")) {
                if (!player.hasPermission("waypoints.use.info")) {
                    player.sendMessage(ChatColor.RED + "You do not have permissions to use this command!");
                    return true;
                }
                if (args.length != 2) {
                    player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp help" + ChatColor.RED + " for more help!");
                    return true;
                }
                Waypoints.displayWaypointsInfo(player, args[1].toString());
                return true;
            }
            if (args[0].equalsIgnoreCase("admin")) {
                if (!player.hasPermission("waypoints.admin")) {
                    player.sendMessage(ChatColor.RED + "You do not have permissions to use this command!");
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp admin help" + ChatColor.RED + " for more help!");
                    return true;
                }
                AdminCommand.adminCommand(player, args);
                return true;
            }
            player.sendMessage(ChatColor.RED + "Incorrect command usage, use " + ChatColor.DARK_RED + "/wp help" + ChatColor.RED + " for more help!");
            return true;
        }
        return false;
    }
}

