/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Comp {
    @NotNull
    public static final Pattern HEX_COLOR = Pattern.compile("&#(?<hex>[0-9a-fA-F]{6})");

    private Comp() {
    }

    @NotNull
    public static String preprocessHexColors(@NotNull String text) {
        ArrayList<MatchResult> results = new ArrayList<MatchResult>();
        Matcher matcher = HEX_COLOR.matcher(text);
        StringBuilder builder = new StringBuilder(text);
        while (matcher.find()) {
            results.add(matcher.toMatchResult());
        }
        Collections.reverse(results);
        for (MatchResult result : results) {
            builder.replace(result.start(), result.end(), Comp.transformHexColor(result.group(1)));
        }
        return builder.toString();
    }

    @NotNull
    public static String transformHexColor(@NotNull String hex) {
        return String.format("%sx%s", Character.valueOf('\u00a7'), hex.replaceAll(".", String.format("%s$0", Character.valueOf('\u00a7'))));
    }

    @NotNull
    public static BaseComponent[] of(@NotNull String text) {
        return TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)Comp.preprocessHexColors(text)));
    }

    @NotNull
    public static TextComponent ofText(@NotNull String text) {
        return Comp.ofBase(Comp.of(text));
    }

    @NotNull
    public static TextComponent ofBase(@NotNull BaseComponent[] components) {
        return new TextComponent(components);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static ComponentBuilder build() {
        return new ComponentBuilder();
    }

    @Contract(value="_ -> param1")
    @NotNull
    public static ComponentBuilder clean(@NotNull ComponentBuilder builder) {
        Iterator iterator = builder.getParts().iterator();
        while (iterator.hasNext()) {
            TextComponent text;
            BaseComponent next = (BaseComponent)iterator.next();
            if (!(next instanceof TextComponent) || (text = (TextComponent)next).getText() != null && !text.getText().isEmpty() || text.getExtra() != null && !text.getExtra().isEmpty() || text.getClickEvent() != null || text.getHoverEvent() != null) continue;
            iterator.remove();
        }
        return builder;
    }

    public static void walk(@NotNull BaseComponent[] components, @NotNull ComponentVisitor visitor) {
        Arrays.stream(components).forEach(component -> Comp.walk(component, visitor));
    }

    private static void walk(@NotNull BaseComponent component, @NotNull ComponentVisitor visitor) {
        visitor.visit(component);
        List extra = component.getExtra();
        if (extra == null || extra.isEmpty()) {
            return;
        }
        extra.forEach(other -> Comp.walk(other, visitor));
    }

    @NotNull
    public static BaseComponent[] filter(@NotNull BaseComponent[] components, @NotNull Predicate<BaseComponent> predicate) {
        ArrayList matches = new ArrayList();
        Comp.walk(components, (BaseComponent component) -> {
            if (predicate.test(component)) {
                matches.add(component);
            }
        });
        return matches.toArray(new BaseComponent[0]);
    }

    @FunctionalInterface
    public static interface ComponentVisitor {
        public void visit(@NotNull BaseComponent var1);
    }
}

