/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.libs.parser;

import com.sxtanna.mc.chat.libs.Extension;
import com.sxtanna.mc.chat.libs.internal.DocumentParser;
import com.sxtanna.mc.chat.libs.internal.InlineParserContextImpl;
import com.sxtanna.mc.chat.libs.internal.InlineParserImpl;
import com.sxtanna.mc.chat.libs.node.Block;
import com.sxtanna.mc.chat.libs.node.Document;
import com.sxtanna.mc.chat.libs.node.Node;
import com.sxtanna.mc.chat.libs.parser.IncludeSourceSpans;
import com.sxtanna.mc.chat.libs.parser.InlineParser;
import com.sxtanna.mc.chat.libs.parser.InlineParserContext;
import com.sxtanna.mc.chat.libs.parser.InlineParserFactory;
import com.sxtanna.mc.chat.libs.parser.PostProcessor;
import com.sxtanna.mc.chat.libs.parser.block.BlockParserFactory;
import com.sxtanna.mc.chat.libs.parser.delimiter.DelimiterProcessor;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Parser {
    private final List<BlockParserFactory> blockParserFactories;
    private final List<DelimiterProcessor> delimiterProcessors;
    private final InlineParserFactory inlineParserFactory;
    private final List<PostProcessor> postProcessors;
    private final IncludeSourceSpans includeSourceSpans;

    private Parser(Builder builder) {
        this.blockParserFactories = DocumentParser.calculateBlockParserFactories(builder.blockParserFactories, builder.enabledBlockTypes);
        this.inlineParserFactory = builder.getInlineParserFactory();
        this.postProcessors = builder.postProcessors;
        this.delimiterProcessors = builder.delimiterProcessors;
        this.includeSourceSpans = builder.includeSourceSpans;
        this.inlineParserFactory.create(new InlineParserContextImpl(this.delimiterProcessors, Collections.emptyMap()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Node parse(String input) {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        DocumentParser documentParser = this.createDocumentParser();
        Document document = documentParser.parse(input);
        return this.postProcess(document);
    }

    public Node parseReader(Reader input) throws IOException {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        DocumentParser documentParser = this.createDocumentParser();
        Document document = documentParser.parse(input);
        return this.postProcess(document);
    }

    private DocumentParser createDocumentParser() {
        return new DocumentParser(this.blockParserFactories, this.inlineParserFactory, this.delimiterProcessors, this.includeSourceSpans);
    }

    private Node postProcess(Node document) {
        for (PostProcessor postProcessor : this.postProcessors) {
            document = postProcessor.process(document);
        }
        return document;
    }

    public static interface ParserExtension
    extends Extension {
        public void extend(Builder var1);
    }

    public static class Builder {
        private final List<BlockParserFactory> blockParserFactories = new ArrayList<BlockParserFactory>();
        private final List<DelimiterProcessor> delimiterProcessors = new ArrayList<DelimiterProcessor>();
        private final List<PostProcessor> postProcessors = new ArrayList<PostProcessor>();
        private Set<Class<? extends Block>> enabledBlockTypes = DocumentParser.getDefaultBlockParserTypes();
        private InlineParserFactory inlineParserFactory;
        private IncludeSourceSpans includeSourceSpans = IncludeSourceSpans.NONE;

        public Parser build() {
            return new Parser(this);
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            if (extensions == null) {
                throw new NullPointerException("extensions must not be null");
            }
            for (Extension extension : extensions) {
                if (!(extension instanceof ParserExtension)) continue;
                ParserExtension parserExtension = (ParserExtension)extension;
                parserExtension.extend(this);
            }
            return this;
        }

        public Builder enabledBlockTypes(Set<Class<? extends Block>> enabledBlockTypes) {
            if (enabledBlockTypes == null) {
                throw new NullPointerException("enabledBlockTypes must not be null");
            }
            this.enabledBlockTypes = enabledBlockTypes;
            return this;
        }

        public Builder includeSourceSpans(IncludeSourceSpans includeSourceSpans) {
            this.includeSourceSpans = includeSourceSpans;
            return this;
        }

        public Builder customBlockParserFactory(BlockParserFactory blockParserFactory) {
            if (blockParserFactory == null) {
                throw new NullPointerException("blockParserFactory must not be null");
            }
            this.blockParserFactories.add(blockParserFactory);
            return this;
        }

        public Builder customDelimiterProcessor(DelimiterProcessor delimiterProcessor) {
            if (delimiterProcessor == null) {
                throw new NullPointerException("delimiterProcessor must not be null");
            }
            this.delimiterProcessors.add(delimiterProcessor);
            return this;
        }

        public Builder postProcessor(PostProcessor postProcessor) {
            if (postProcessor == null) {
                throw new NullPointerException("postProcessor must not be null");
            }
            this.postProcessors.add(postProcessor);
            return this;
        }

        public Builder inlineParserFactory(InlineParserFactory inlineParserFactory) {
            this.inlineParserFactory = inlineParserFactory;
            return this;
        }

        private InlineParserFactory getInlineParserFactory() {
            if (this.inlineParserFactory != null) {
                return this.inlineParserFactory;
            }
            return new InlineParserFactory(){

                @Override
                public InlineParser create(InlineParserContext inlineParserContext) {
                    return new InlineParserImpl(inlineParserContext);
                }
            };
        }
    }
}

