/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.libs.internal.util;

import com.sxtanna.mc.chat.libs.internal.inline.Scanner;
import com.sxtanna.mc.chat.libs.internal.util.Parsing;

public class LinkScanner {
    public static boolean scanLinkLabelContent(Scanner scanner) {
        block5: while (scanner.hasNext()) {
            switch (scanner.peek()) {
                case '\\': {
                    scanner.next();
                    if (!Parsing.isEscapable(scanner.peek())) continue block5;
                    scanner.next();
                    continue block5;
                }
                case ']': {
                    return true;
                }
                case '[': {
                    return false;
                }
            }
            scanner.next();
        }
        return true;
    }

    public static boolean scanLinkDestination(Scanner scanner) {
        if (!scanner.hasNext()) {
            return false;
        }
        if (scanner.next('<')) {
            block5: while (scanner.hasNext()) {
                switch (scanner.peek()) {
                    case '\\': {
                        scanner.next();
                        if (!Parsing.isEscapable(scanner.peek())) continue block5;
                        scanner.next();
                        continue block5;
                    }
                    case '\n': 
                    case '<': {
                        return false;
                    }
                    case '>': {
                        scanner.next();
                        return true;
                    }
                }
                scanner.next();
            }
            return false;
        }
        return LinkScanner.scanLinkDestinationWithBalancedParens(scanner);
    }

    public static boolean scanLinkTitle(Scanner scanner) {
        char endDelimiter;
        if (!scanner.hasNext()) {
            return false;
        }
        switch (scanner.peek()) {
            case '\"': {
                endDelimiter = '\"';
                break;
            }
            case '\'': {
                endDelimiter = '\'';
                break;
            }
            case '(': {
                endDelimiter = ')';
                break;
            }
            default: {
                return false;
            }
        }
        scanner.next();
        if (!LinkScanner.scanLinkTitleContent(scanner, endDelimiter)) {
            return false;
        }
        if (!scanner.hasNext()) {
            return false;
        }
        scanner.next();
        return true;
    }

    public static boolean scanLinkTitleContent(Scanner scanner, char endDelimiter) {
        while (scanner.hasNext()) {
            char c = scanner.peek();
            if (c == '\\') {
                scanner.next();
                if (!Parsing.isEscapable(scanner.peek())) continue;
                scanner.next();
                continue;
            }
            if (c == endDelimiter) {
                return true;
            }
            if (endDelimiter == ')' && c == '(') {
                return false;
            }
            scanner.next();
        }
        return true;
    }

    private static boolean scanLinkDestinationWithBalancedParens(Scanner scanner) {
        int parens = 0;
        boolean empty = true;
        while (scanner.hasNext()) {
            char c = scanner.peek();
            switch (c) {
                case ' ': {
                    return !empty;
                }
                case '\\': {
                    scanner.next();
                    if (!Parsing.isEscapable(scanner.peek())) break;
                    scanner.next();
                    break;
                }
                case '(': {
                    if (++parens > 32) {
                        return false;
                    }
                    scanner.next();
                    break;
                }
                case ')': {
                    if (parens == 0) {
                        return true;
                    }
                    --parens;
                    scanner.next();
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        return !empty;
                    }
                    scanner.next();
                }
            }
            empty = false;
        }
        return true;
    }
}

