/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.libs.internal;

import com.sxtanna.mc.chat.libs.internal.LinkReferenceDefinitionParser;
import com.sxtanna.mc.chat.libs.node.Block;
import com.sxtanna.mc.chat.libs.node.LinkReferenceDefinition;
import com.sxtanna.mc.chat.libs.node.Paragraph;
import com.sxtanna.mc.chat.libs.node.SourceSpan;
import com.sxtanna.mc.chat.libs.parser.InlineParser;
import com.sxtanna.mc.chat.libs.parser.SourceLine;
import com.sxtanna.mc.chat.libs.parser.SourceLines;
import com.sxtanna.mc.chat.libs.parser.block.AbstractBlockParser;
import com.sxtanna.mc.chat.libs.parser.block.BlockContinue;
import com.sxtanna.mc.chat.libs.parser.block.ParserState;
import java.util.List;

public class ParagraphParser
extends AbstractBlockParser {
    private final Paragraph block = new Paragraph();
    private final LinkReferenceDefinitionParser linkReferenceDefinitionParser = new LinkReferenceDefinitionParser();

    @Override
    public boolean canHaveLazyContinuationLines() {
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (!state.isBlank()) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.linkReferenceDefinitionParser.parse(line);
    }

    @Override
    public void addSourceSpan(SourceSpan sourceSpan) {
        this.linkReferenceDefinitionParser.addSourceSpan(sourceSpan);
    }

    @Override
    public void closeBlock() {
        if (this.linkReferenceDefinitionParser.getParagraphLines().isEmpty()) {
            this.block.unlink();
        } else {
            this.block.setSourceSpans(this.linkReferenceDefinitionParser.getParagraphSourceSpans());
        }
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        SourceLines lines = this.linkReferenceDefinitionParser.getParagraphLines();
        if (!lines.isEmpty()) {
            inlineParser.parse(lines, this.block);
        }
    }

    public SourceLines getParagraphLines() {
        return this.linkReferenceDefinitionParser.getParagraphLines();
    }

    public List<LinkReferenceDefinition> getDefinitions() {
        return this.linkReferenceDefinitionParser.getDefinitions();
    }
}

