/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.libs.internal;

import com.sxtanna.mc.chat.libs.node.Block;
import com.sxtanna.mc.chat.libs.node.ListBlock;
import com.sxtanna.mc.chat.libs.node.ListItem;
import com.sxtanna.mc.chat.libs.node.Paragraph;
import com.sxtanna.mc.chat.libs.parser.block.AbstractBlockParser;
import com.sxtanna.mc.chat.libs.parser.block.BlockContinue;
import com.sxtanna.mc.chat.libs.parser.block.ParserState;

public class ListItemParser
extends AbstractBlockParser {
    private final ListItem block = new ListItem();
    private int contentIndent;
    private boolean hadBlankLine;

    public ListItemParser(int contentIndent) {
        this.contentIndent = contentIndent;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block childBlock) {
        Block parent;
        if (this.hadBlankLine && (parent = this.block.getParent()) instanceof ListBlock) {
            ((ListBlock)parent).setTight(false);
        }
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.isBlank()) {
            if (this.block.getFirstChild() == null) {
                return BlockContinue.none();
            }
            Block activeBlock = state.getActiveBlockParser().getBlock();
            this.hadBlankLine = activeBlock instanceof Paragraph || activeBlock instanceof ListItem;
            return BlockContinue.atIndex(state.getNextNonSpaceIndex());
        }
        if (state.getIndent() >= this.contentIndent) {
            return BlockContinue.atColumn(state.getColumn() + this.contentIndent);
        }
        return BlockContinue.none();
    }
}

