/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.hook;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import com.sxtanna.mc.chat.base.State;
import com.sxtanna.mc.chat.hook.IAFontImages;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Placeholders
implements State {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final List<Replacer> hooked = new ArrayList<Replacer>();

    public Placeholders(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        ArrayList<String> added = new ArrayList<String>();
        if (this.plugin.getConfig().getBoolean("options.extras.replacers.clip_papi") && Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            try {
                this.hooked.add(me.clip.placeholderapi.PlaceholderAPI::setPlaceholders);
                added.add("PlaceholderAPI");
            }
            catch (Throwable ex) {
                this.plugin.getLogger().log(Level.WARNING, "failed to register replacer for PlaceholderAPI", ex);
            }
        }
        if (this.plugin.getConfig().getBoolean("options.extras.replacers.mvdw_papi") && Bukkit.getServer().getPluginManager().isPluginEnabled("MVdWPlaceholderAPI")) {
            try {
                this.hooked.add(PlaceholderAPI::replacePlaceholders);
                added.add("MVdWPlaceholderAPI");
            }
            catch (Throwable ex) {
                this.plugin.getLogger().log(Level.WARNING, "failed to register replacer for MVdWPlaceholderAPI", ex);
            }
        }
        if (added.isEmpty()) {
            this.hooked.add((player, text) -> {
                Player online;
                Player player2 = online = player == null ? null : player.getPlayer();
                if (online == null) {
                    return text;
                }
                String replaced = text;
                String name = player.getName();
                if (name != null) {
                    replaced = replaced.replace("%player%", name);
                }
                return replaced;
            });
        }
        if (this.plugin.getConfig().getBoolean("options.extras.replacers.items_adder.in_formats")) {
            try {
                Replacer replacer = IAFontImages.get();
                if (replacer != null) {
                    this.hooked.add(($, text) -> replacer.replace(null, text));
                    added.add("ItemsAdder");
                }
            }
            catch (Throwable ex) {
                this.plugin.getLogger().log(Level.WARNING, "failed to register replacer for ItemsAdder", ex);
            }
        }
        if (!added.isEmpty()) {
            this.plugin.getLogger().info("Successfully registered replacers for " + added + ".");
        }
    }

    @Override
    public void kill() {
        this.hooked.clear();
    }

    @NotNull
    public String apply(@Nullable OfflinePlayer player, @NotNull String text) {
        if (this.hooked.isEmpty()) {
            return text;
        }
        return this.hooked.stream().reduce(text, (next, replacer) -> replacer.replace(player, (String)next), String::concat);
    }

    @FunctionalInterface
    public static interface Replacer {
        @NotNull
        public String replace(@Nullable OfflinePlayer var1, @NotNull String var2);
    }
}

