/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.core.reader;

import com.google.common.collect.ImmutableSet;
import com.sxtanna.mc.chat.VoxChat;
import com.sxtanna.mc.chat.core.data.ActionType;
import com.sxtanna.mc.chat.libs.node.AbstractVisitor;
import com.sxtanna.mc.chat.libs.node.Document;
import com.sxtanna.mc.chat.libs.node.Emphasis;
import com.sxtanna.mc.chat.libs.node.Link;
import com.sxtanna.mc.chat.libs.node.Node;
import com.sxtanna.mc.chat.libs.node.Paragraph;
import com.sxtanna.mc.chat.libs.node.StrongEmphasis;
import com.sxtanna.mc.chat.libs.node.Text;
import com.sxtanna.mc.chat.libs.renderer.NodeRenderer;
import com.sxtanna.mc.chat.util.Comp;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class VoxChatRender
extends AbstractVisitor
implements NodeRenderer {
    @NotNull
    private final Player player;
    @NotNull
    private final ComponentBuilder builder = Comp.build();
    private boolean ital;
    private boolean bold;

    public VoxChatRender(@NotNull Player player) {
        this.player = player;
    }

    @NotNull
    public ComponentBuilder getBuilder() {
        return Comp.clean(this.builder);
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return ImmutableSet.of(Document.class, Paragraph.class);
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Emphasis emphasis) {
        this.ital = true;
        this.visitChildren(emphasis);
        this.ital = false;
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.bold = true;
        this.visitChildren(strongEmphasis);
        this.bold = false;
    }

    @Override
    public void visit(Text text) {
        this.builder.append((BaseComponent)Comp.ofText(VoxChat.getReplacer().apply((OfflinePlayer)this.player, text.getLiteral())), this.currentHasText() ? ComponentBuilder.FormatRetention.NONE : ComponentBuilder.FormatRetention.FORMATTING);
        if (this.ital) {
            this.builder.italic(true);
        }
        if (this.bold) {
            this.builder.bold(true);
        }
    }

    @Override
    public void visit(Link link) {
        this.visitChildren(link);
        this.cleanseEmpty();
        for (String dest : link.getDestination().replace(" ", "").split("[,|:/]")) {
            String[] path = dest.split("\\.");
            if (path.length != 2) continue;
            ActionType.find(path[0]).flatMap(type -> VoxChat.getActionManager().find((ActionType)((Object)type), path[1])).ifPresent(data -> {
                data.getClickEvent().ifPresent(arg_0 -> ((ComponentBuilder)this.builder).event(arg_0));
                data.getHoverEvent().ifPresent(arg_0 -> ((ComponentBuilder)this.builder).event(arg_0));
            });
        }
    }

    private boolean currentHasText() {
        BaseComponent current = this.builder.getCurrentComponent();
        return current instanceof TextComponent && !((TextComponent)current).getText().isEmpty();
    }

    private void cleanseEmpty() {
        while (!(this.builder.getParts().isEmpty() || this.currentHasText() || this.builder.getCurrentComponent().getExtra() != null && !this.builder.getCurrentComponent().getExtra().isEmpty())) {
            this.builder.resetCursor().removeComponent(this.builder.getCursor());
        }
    }
}

