/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.core.events;

import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class VoxChatEvent
extends Event
implements Cancellable {
    @NotNull
    private static final HandlerList HANDLERS = new HandlerList();
    @NotNull
    private final Player player;
    @NotNull
    private final String format;
    @NotNull
    private String message;
    private boolean cancelled;

    public VoxChatEvent(boolean async, @NotNull Player player, @NotNull String format, @NotNull String message) {
        super(async);
        this.player = player;
        this.format = format;
        this.message = message;
    }

    public VoxChatEvent(@NotNull Player player, @NotNull String format, @NotNull String message) {
        this(true, player, format, message);
    }

    @Contract(pure=true)
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Contract(pure=true)
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Contract(pure=true)
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @Contract(mutates="this")
    public void setMessage(@NotNull String message) {
        this.message = message;
    }

    @Contract(pure=true)
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Contract(mutates="this")
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Contract(pure=true)
    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VoxChatEvent)) {
            return false;
        }
        VoxChatEvent that = (VoxChatEvent)((Object)o);
        return this.cancelled == that.cancelled && this.player.equals(that.player) && this.format.equals(that.format) && this.message.equals(that.message);
    }

    public int hashCode() {
        return Objects.hash(this.player, this.format, this.message, this.cancelled);
    }

    public String toString() {
        return String.format("VoxChatEvent[player=%s, format='%s', message='%s', cancelled=%s, handlers=%s]", this.player, this.format, this.message, this.cancelled, this.getHandlers());
    }

    @Contract(pure=true)
    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

