/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.core.events;

import com.google.common.collect.Sets;
import com.sxtanna.mc.chat.VoxChat;
import com.sxtanna.mc.chat.VoxChatPlugin;
import com.sxtanna.mc.chat.base.State;
import com.sxtanna.mc.chat.core.events.VoxChatEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ChatListener
implements State,
Listener {
    @NotNull
    private final VoxChatPlugin plugin;
    private boolean loaded;
    private final AtomicInteger sent = new AtomicInteger();

    public ChatListener(@NotNull VoxChatPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.loaded = true;
    }

    @Override
    public void kill() {
        HandlerList.unregisterAll((Listener)this);
        this.loaded = false;
    }

    @Contract(pure=true)
    public boolean isLoaded() {
        return this.loaded;
    }

    public int getSentMessages() {
        return this.sent.get();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChat(@NotNull AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        Optional<String> formatName = VoxChat.find(player);
        if (!formatName.isPresent()) {
            return;
        }
        VoxChatEvent voxChatEvent = new VoxChatEvent(event.isAsynchronous(), player, formatName.get(), message);
        this.plugin.getServer().getPluginManager().callEvent((Event)voxChatEvent);
        if (voxChatEvent.isCancelled()) {
            return;
        }
        boolean messageWasSent = VoxChat.send(voxChatEvent.getFormat(), voxChatEvent.getPlayer(), voxChatEvent.getMessage(), (Collection<? extends CommandSender>)Sets.union(Collections.singleton(Bukkit.getConsoleSender()), (Set)event.getRecipients()));
        if (!messageWasSent) {
            return;
        }
        this.sent.incrementAndGet();
        if (this.plugin.getConfig().getBoolean("options.cancel_chat_event", false)) {
            event.setCancelled(true);
        } else {
            try {
                event.getRecipients().clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

