/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.core.data;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class FormatData {
    @NotNull
    private final String name;
    private final boolean allowColors;
    private final boolean allowFormat;
    @NotNull
    private final String formatText;

    public FormatData(@NotNull String name, boolean allowColors, boolean allowFormat, @NotNull String formatText) {
        this.name = name;
        this.allowColors = allowColors;
        this.allowFormat = allowFormat;
        this.formatText = formatText;
    }

    @Contract(pure=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Contract(pure=true)
    public boolean allowsColors() {
        return this.allowColors;
    }

    @Contract(pure=true)
    public boolean allowsFormat() {
        return this.allowFormat;
    }

    @Contract(pure=true)
    @NotNull
    public String getFormatText() {
        return this.formatText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FormatData)) {
            return false;
        }
        FormatData that = (FormatData)o;
        return this.allowColors == that.allowColors && this.allowFormat == that.allowFormat && this.name.equals(that.name) && this.formatText.equals(that.formatText);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.allowColors, this.allowFormat, this.formatText);
    }

    public String toString() {
        return String.format("FormatData[name='%s', colors=%s, format=%s, formatText='%s']", this.name, this.allowColors, this.allowFormat, this.formatText);
    }
}

