/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.core.data;

import com.sxtanna.mc.chat.core.data.ActionData;
import java.util.Optional;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public enum ActionType {
    HOVER{

        @Override
        @NotNull
        public Optional<ActionData> read(@NotNull ConfigurationSection section) {
            String text = !section.isList("text") ? section.getString("text") : String.join((CharSequence)"\n", section.getStringList("text"));
            return text == null ? Optional.empty() : Optional.of(ActionData.hover(text));
        }
    }
    ,
    CLICK{

        @Override
        @NotNull
        public Optional<ActionData> read(@NotNull ConfigurationSection section) {
            ActionData data;
            Set keys = section.getKeys(false);
            if (keys.size() != 1) {
                return Optional.empty();
            }
            String k = (String)keys.iterator().next();
            String v = section.getString(k);
            if (v == null || v.isEmpty()) {
                return Optional.empty();
            }
            switch (k.toLowerCase()) {
                case "exec_cmd": {
                    data = ActionData.clickExecCmd(v);
                    break;
                }
                case "show_cmd": {
                    data = ActionData.clickShowCmd(v);
                    break;
                }
                case "open_url": {
                    data = ActionData.clickOpenUrl(v);
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(data);
        }
    };


    @NotNull
    public abstract Optional<ActionData> read(@NotNull ConfigurationSection var1);

    @NotNull
    public static Optional<ActionType> find(@NotNull String name) {
        switch (name.toLowerCase()) {
            case "hover": {
                return Optional.of(HOVER);
            }
            case "click": {
                return Optional.of(CLICK);
            }
        }
        return Optional.empty();
    }
}

