/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.core.data;

import com.sxtanna.mc.chat.util.Comp;
import java.util.Objects;
import java.util.Optional;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class ActionData {
    @NotNull
    private final String text;

    ActionData(@NotNull String text) {
        this.text = text;
    }

    @Contract(pure=true)
    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public Optional<ClickEvent> getClickEvent() {
        return Optional.empty();
    }

    @NotNull
    public Optional<HoverEvent> getHoverEvent() {
        return Optional.empty();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        ActionData that = (ActionData)o;
        return this.text.equals(that.text);
    }

    public final int hashCode() {
        return Objects.hash(this.text);
    }

    public final String toString() {
        return String.format("%s['%s']", this.getClass().getSimpleName(), this.text);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ActionData hover(@NotNull String text) {
        return new ActionDataHover(text);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ActionData clickExecCmd(@NotNull String text) {
        return new ActionDataClickExecCmd(text);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ActionData clickShowCmd(@NotNull String text) {
        return new ActionDataClickShowCmd(text);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ActionData clickOpenUrl(@NotNull String text) {
        return new ActionDataClickOpenUrl(text);
    }

    private static final class ActionDataClickOpenUrl
    extends ActionData {
        private ActionDataClickOpenUrl(@NotNull String text) {
            super(text);
        }

        @Override
        @NotNull
        public Optional<ClickEvent> getClickEvent() {
            return Optional.of(new ClickEvent(ClickEvent.Action.OPEN_URL, this.getText()));
        }
    }

    private static final class ActionDataClickShowCmd
    extends ActionData {
        private ActionDataClickShowCmd(@NotNull String text) {
            super(text);
        }

        @Override
        @NotNull
        public Optional<ClickEvent> getClickEvent() {
            return Optional.of(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, this.getText()));
        }
    }

    private static final class ActionDataClickExecCmd
    extends ActionData {
        private ActionDataClickExecCmd(@NotNull String text) {
            super(text);
        }

        @Override
        @NotNull
        public Optional<ClickEvent> getClickEvent() {
            return Optional.of(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.getText()));
        }
    }

    private static final class ActionDataHover
    extends ActionData {
        private ActionDataHover(@NotNull String text) {
            super(text);
        }

        @Override
        @NotNull
        public Optional<HoverEvent> getHoverEvent() {
            return Optional.of(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(Comp.of(this.getText()))}));
        }
    }
}

