/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.core;

import com.google.common.collect.ImmutableSet;
import com.sxtanna.mc.chat.VoxChatPlugin;
import com.sxtanna.mc.chat.base.State;
import com.sxtanna.mc.chat.core.data.FormatData;
import com.sxtanna.mc.chat.core.reader.VoxChatReader;
import com.sxtanna.mc.chat.core.reader.VoxChatRender;
import com.sxtanna.mc.chat.libs.node.Node;
import com.sxtanna.mc.chat.util.Comp;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class FormatManager
implements State {
    @NotNull
    private final VoxChatReader reader = new VoxChatReader();
    @NotNull
    private final VoxChatPlugin plugin;
    @NotNull
    private final Map<String, FormatData> cached = new HashMap<String, FormatData>();

    public FormatManager(@NotNull VoxChatPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadFormats();
    }

    @Override
    public void kill() {
        this.cached.clear();
    }

    public int size() {
        return this.cached.size();
    }

    @NotNull
    public @Unmodifiable Set<String> list() {
        return ImmutableSet.copyOf(this.cached.keySet());
    }

    @NotNull
    public Optional<FormatData> find(@NotNull String name) {
        return Optional.ofNullable(this.cached.get(name.toLowerCase()));
    }

    public void save(@NotNull FormatData data) {
        this.cached.put(data.getName().toLowerCase(), data);
    }

    @NotNull
    public Optional<BaseComponent[]> prepare(@NotNull String name, @NotNull Player player, @NotNull String message) {
        Optional<FormatData> data = this.find(name);
        if (!data.isPresent()) {
            return Optional.empty();
        }
        Optional<Node> node = this.reader.read(data.get().getFormatText());
        if (!node.isPresent()) {
            return Optional.empty();
        }
        VoxChatRender render = new VoxChatRender(player);
        render.render(node.get());
        BaseComponent[] renderComponents = render.getBuilder().create();
        this.walkReplacing((OfflinePlayer)player, renderComponents);
        BaseComponent[] searchComponents = Comp.filter(renderComponents, component -> component instanceof TextComponent && ((TextComponent)component).getText().contains("%message%"));
        if (searchComponents.length == 1) {
            String bypassPermission;
            TextComponent text = (TextComponent)searchComponents[0];
            text.setText(text.getText().replace("%message%", ""));
            BaseComponent[] messageComponent = Comp.of(message);
            if (!(data.get().allowsColors() || (bypassPermission = this.plugin.getConfig().getString("options.bypass.colors_permission")) != null && player.hasPermission(bypassPermission))) {
                Comp.walk(messageComponent, component -> component.setColor(null));
            }
            if (!(data.get().allowsFormat() || player.hasPermission("voxchat.bypass.format") || (bypassPermission = this.plugin.getConfig().getString("options.bypass.format_permission")) != null && player.hasPermission(bypassPermission))) {
                Comp.walk(messageComponent, component -> {
                    component.setBold(null);
                    component.setItalic(null);
                    component.setUnderlined(null);
                    component.setObfuscated(null);
                    component.setStrikethrough(null);
                });
            }
            for (BaseComponent component2 : messageComponent) {
                text.addExtra(component2);
            }
        }
        return Optional.of(renderComponents);
    }

    private void loadFormats() {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("formats");
        if (section == null) {
            return;
        }
        for (String name : section.getKeys(false)) {
            String formatText;
            ConfigurationSection formatSection = section.getConfigurationSection(name);
            if (formatSection == null || (formatText = formatSection.getString("format")) == null) continue;
            boolean allowColors = formatSection.getBoolean("allows.colors", false);
            boolean allowFormat = formatSection.getBoolean("allows.format", false);
            this.save(new FormatData(name, allowColors, allowFormat, formatText));
        }
    }

    private void walkReplacing(@Nullable OfflinePlayer player, @NotNull BaseComponent[] components) {
        Comp.walk(components, component -> {
            ClickEvent clickEvent;
            HoverEvent hoverEvent = component.getHoverEvent();
            if (hoverEvent != null) {
                this.walkReplacingHoverEvent(player, hoverEvent);
            }
            if ((clickEvent = component.getClickEvent()) != null) {
                component.setClickEvent(new ClickEvent(clickEvent.getAction(), this.plugin.getReplacer().apply(player, clickEvent.getValue())));
            }
            if (!(component instanceof TextComponent)) {
                return;
            }
            TextComponent text = (TextComponent)component;
            text.setText(this.plugin.getReplacer().apply(player, text.getText()));
        });
    }

    private void walkReplacingHoverEvent(@Nullable OfflinePlayer player, @NotNull HoverEvent event) {
        event.getContents().replaceAll(content -> {
            if (!(content instanceof Text)) {
                return content;
            }
            Object value = ((Text)content).getValue();
            if (value instanceof String) {
                String textValue = (String)value;
                return new Text(this.plugin.getReplacer().apply(player, textValue));
            }
            if (value instanceof BaseComponent[]) {
                BaseComponent[] compValue = (BaseComponent[])value;
                this.walkReplacing(player, compValue);
                return new Text(compValue);
            }
            return content;
        });
    }
}

