/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.core;

import com.sxtanna.mc.chat.VoxChatPlugin;
import com.sxtanna.mc.chat.base.State;
import com.sxtanna.mc.chat.core.data.ActionData;
import com.sxtanna.mc.chat.core.data.ActionType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public final class ActionManager
implements State {
    @NotNull
    private final VoxChatPlugin plugin;
    @NotNull
    private final Map<ActionType, Map<String, ActionData>> cached = new HashMap<ActionType, Map<String, ActionData>>();

    public ActionManager(@NotNull VoxChatPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadActions();
    }

    @Override
    public void kill() {
        this.cached.clear();
    }

    @NotNull
    public Optional<ActionData> find(@NotNull ActionType type, @NotNull String name) {
        return Optional.ofNullable(this.cached.get((Object)type)).map(map -> (ActionData)map.get(name.toLowerCase()));
    }

    public void save(@NotNull ActionType type, @NotNull String name, @NotNull ActionData action) {
        this.cached.computeIfAbsent(type, $ -> new HashMap()).put(name.toLowerCase(), action);
    }

    private void loadActions() {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("actions");
        if (section == null) {
            return;
        }
        for (ActionType type : ActionType.values()) {
            ConfigurationSection typeSection = section.getConfigurationSection(type.name().toLowerCase());
            if (typeSection == null) continue;
            for (String key : typeSection.getKeys(false)) {
                Optional<ActionData> data;
                ConfigurationSection dataSection = typeSection.getConfigurationSection(key);
                if (dataSection == null || !(data = type.read(dataSection)).isPresent()) continue;
                this.save(type, key, data.get());
            }
        }
    }
}

