/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.cmds.impl;

import com.sxtanna.mc.chat.VoxChat;
import com.sxtanna.mc.chat.cmds.VoxChatCommand;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CommandFormat
extends VoxChatCommand {
    public CommandFormat() {
        super("format", new String[0]);
    }

    @Override
    protected void evaluate(@NotNull CommandSender sender, @NotNull String label, @NotNull @Unmodifiable List<String> params) {
        if (!(sender instanceof Player)) {
            sender.spigot().sendMessage(this.prefix().append(" you must be a player to do this.").color(ChatColor.RED).create());
            return;
        }
        if (params.size() < 1) {
            sender.spigot().sendMessage(this.prefix().append(" not enough arguments.").color(ChatColor.RED).create());
            return;
        }
        if (params.size() > 1) {
            sender.spigot().sendMessage(this.prefix().append(" too many arguments.").color(ChatColor.RED).create());
            return;
        }
        Player player = (Player)sender;
        String format = params.get(0);
        if (!VoxChat.getFormatManager().find(format).isPresent()) {
            sender.spigot().sendMessage(this.prefix().append(" there is no format by that name.").color(ChatColor.RED).create());
            return;
        }
        boolean messageWasSent = VoxChat.send(format, player, "Hi, this is&l a&a test&f message! :D", Collections.singleton(sender));
        if (!messageWasSent) {
            sender.spigot().sendMessage(this.prefix().append(" failed to send message.").color(ChatColor.RED).create());
        }
    }

    @Override
    protected void complete(@NotNull CommandSender sender, @NotNull String label, @NotNull @Unmodifiable List<String> params, @NotNull List<String> suggestions) {
        if (params.size() > 1) {
            return;
        }
        this.getPlugin().getFormatManager().list().stream().filter(possible -> params.isEmpty() || possible.toLowerCase().startsWith(((String)params.get(0)).toLowerCase())).forEach(suggestions::add);
    }
}

