/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.cmds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sxtanna.mc.chat.VoxChatPlugin;
import com.sxtanna.mc.chat.cmds.VoxChatCommand;
import com.sxtanna.mc.chat.cmds.impl.CommandFormat;
import com.sxtanna.mc.chat.cmds.impl.CommandHelp;
import com.sxtanna.mc.chat.cmds.impl.CommandReload;
import com.sxtanna.mc.chat.cmds.impl.CommandToggle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class VoxChatCommandRouter
implements CommandExecutor,
TabCompleter {
    @NotNull
    private static final @Unmodifiable List<VoxChatCommand> COMMANDS = ImmutableList.of((Object)new CommandHelp(), (Object)new CommandFormat(), (Object)new CommandReload(), (Object)new CommandToggle());
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final @Unmodifiable Map<String, VoxChatCommand> lookup;

    @NotNull
    private static @Unmodifiable Map<String, VoxChatCommand> generateLookupMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        COMMANDS.forEach(command -> command.getAllLabels().forEach(label -> builder.put((Object)label.toLowerCase(), command)));
        return builder.build();
    }

    public VoxChatCommandRouter(@NotNull VoxChatPlugin plugin) {
        this.plugin = plugin;
        this.lookup = VoxChatCommandRouter.generateLookupMap();
        COMMANDS.forEach(command -> command.setPlugin(plugin));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            VoxChatCommand help = this.lookup.get("help");
            if (help != null) {
                help.evaluate(sender, "", Collections.emptyList());
            }
            return true;
        }
        String search = args[0].toLowerCase();
        VoxChatCommand target = this.lookup.get(search);
        if (target == null) {
            sender.sendMessage(String.format("%sUnknown command %s'%s%s%s'%s", ChatColor.RED, ChatColor.DARK_GRAY, ChatColor.WHITE, search, ChatColor.DARK_GRAY, ChatColor.RESET));
            return true;
        }
        if (!sender.hasPermission("voxchat.command." + target.getLabel().toLowerCase())) {
            sender.sendMessage(String.format("%sYou do not have permission to do this!%s", ChatColor.RED, ChatColor.RESET));
            return true;
        }
        try {
            target.evaluate(sender, search, (List<String>)ImmutableList.copyOf((Object[])Arrays.copyOfRange(args, 1, args.length)));
        }
        catch (Throwable ex) {
            this.plugin.getLogger().log(Level.SEVERE, "failed to evaluate command:" + target.getLabel(), ex);
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length > 1) {
            VoxChatCommand target2 = this.lookup.get(args[0].toLowerCase());
            if (target2 != null) {
                target2.complete(sender, alias, (List<String>)ImmutableList.copyOf((Object[])Arrays.copyOfRange(args, 1, args.length)), suggestions);
            }
            return suggestions;
        }
        COMMANDS.stream().filter(target -> sender.hasPermission("voxchat.command." + target.getLabel().toLowerCase())).map(VoxChatCommand::getAllLabels).flatMap(Collection::stream).filter(target -> args.length == 0 || target.toLowerCase().startsWith(args[0].toLowerCase())).forEach(suggestions::add);
        return suggestions;
    }
}

