/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat.cmds;

import com.google.common.collect.ImmutableList;
import com.sxtanna.mc.chat.VoxChatPlugin;
import com.sxtanna.mc.chat.util.Comp;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class VoxChatCommand {
    private VoxChatPlugin plugin;
    @NotNull
    private final @Unmodifiable List<String> labels;

    protected VoxChatCommand(@NotNull String label, String ... aliases) {
        this.labels = ImmutableList.builder().add((Object)label).add((Object[])aliases).build();
    }

    @NotNull
    public final String getLabel() {
        return this.labels.get(0);
    }

    @NotNull
    public final @Unmodifiable List<String> getAllLabels() {
        return this.labels;
    }

    @NotNull
    public final @Unmodifiable List<String> getAltLabels() {
        return this.labels.subList(1, this.labels.size());
    }

    protected void evaluate(@NotNull CommandSender sender, @NotNull String label, @NotNull @Unmodifiable List<String> params) {
    }

    protected void complete(@NotNull CommandSender sender, @NotNull String label, @NotNull @Unmodifiable List<String> params, @NotNull List<String> suggestions) {
    }

    @NotNull
    protected final VoxChatPlugin getPlugin() {
        return this.plugin;
    }

    final void setPlugin(@NotNull VoxChatPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    protected final ComponentBuilder prefix() {
        return Comp.build().append("::").color(ChatColor.WHITE).bold(true).append(" VoxChat ").color(ChatColor.DARK_GRAY).bold(true).event(new ClickEvent(ClickEvent.Action.OPEN_URL, this.getPlugin().getDescription().getWebsite())).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(Comp.build().append("v").color(ChatColor.DARK_GRAY).bold(false).append(this.getPlugin().getDescription().getVersion()).color(ChatColor.WHITE).append("\n").append("  - Sxtanna").color(ChatColor.YELLOW).create())})).append("::").color(ChatColor.WHITE).bold(true).append("").retain(ComponentBuilder.FormatRetention.NONE);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VoxChatCommand)) {
            return false;
        }
        VoxChatCommand that = (VoxChatCommand)o;
        return this.labels.equals(that.labels);
    }

    public final int hashCode() {
        return Objects.hash(this.labels);
    }

    public final String toString() {
        return String.format("VoxChatCommand[labels=%s]", this.labels);
    }
}

