/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat;

import com.google.common.io.CharStreams;
import com.sxtanna.mc.chat.VoxChat;
import com.sxtanna.mc.chat.cmds.VoxChatCommandRouter;
import com.sxtanna.mc.chat.core.ActionManager;
import com.sxtanna.mc.chat.core.FormatManager;
import com.sxtanna.mc.chat.core.events.ChatListener;
import com.sxtanna.mc.chat.hook.Placeholders;
import com.sxtanna.mc.chat.stat.bukkit.Metrics;
import com.sxtanna.mc.chat.stat.charts.SimplePie;
import com.sxtanna.mc.chat.stat.charts.SingleLineChart;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class VoxChatPlugin
extends JavaPlugin {
    @NotNull
    private final VoxChat api = new VoxChat(this);
    @NotNull
    private final ActionManager actionManager = new ActionManager(this);
    @NotNull
    private final FormatManager formatManager = new FormatManager(this);
    @NotNull
    private final ChatListener listener = new ChatListener(this);
    @NotNull
    private final Placeholders replacer = new Placeholders((Plugin)this);

    public void onLoad() {
        this.saveDefaultConfig();
    }

    public void onEnable() {
        if (this.getConfig().getBoolean("options.show_banner_on_start", true)) {
            try {
                Reader banner = this.getTextResource("banner");
                if (banner != null) {
                    this.getLogger().info("\n" + CharStreams.toString((Readable)banner));
                }
            }
            catch (IOException banner) {
                // empty catch block
            }
        }
        this.actionManager.load();
        this.formatManager.load();
        this.replacer.load();
        this.listener.load();
        this.getServer().getServicesManager().register(VoxChat.class, (Object)this.api, (Plugin)this, ServicePriority.Normal);
        VoxChat.INSTANCE = this.api;
        PluginCommand command = this.getCommand("voxchat");
        if (command != null) {
            VoxChatCommandRouter router = new VoxChatCommandRouter(this);
            command.setExecutor((CommandExecutor)router);
            command.setTabCompleter((TabCompleter)router);
        }
        if (this.getConfig().getBoolean("options.use_metrics", true)) {
            try {
                this.initializeMetrics();
            }
            catch (Throwable ex) {
                this.getLogger().log(Level.WARNING, "failed to initialize metrics", ex);
            }
        }
    }

    public void onDisable() {
        this.listener.kill();
        this.replacer.kill();
        this.actionManager.kill();
        this.formatManager.kill();
        PluginCommand command = this.getCommand("voxchat");
        if (command != null) {
            command.setExecutor(null);
            command.setTabCompleter(null);
        }
        this.getServer().getServicesManager().unregister(VoxChat.class, (Object)this.api);
        VoxChat.INSTANCE = null;
    }

    @Contract(pure=true)
    @NotNull
    public ActionManager getActionManager() {
        return this.actionManager;
    }

    @Contract(pure=true)
    @NotNull
    public FormatManager getFormatManager() {
        return this.formatManager;
    }

    @Contract(pure=true)
    @NotNull
    public Placeholders getReplacer() {
        return this.replacer;
    }

    @Contract(pure=true)
    @NotNull
    public ChatListener getListener() {
        return this.listener;
    }

    @NotNull
    public Optional<Throwable> reloadPlugin() {
        try {
            this.replacer.kill();
            this.actionManager.kill();
            this.formatManager.kill();
            this.reloadConfig();
            this.actionManager.load();
            this.formatManager.load();
            this.replacer.load();
        }
        catch (Throwable ex) {
            return Optional.of(ex);
        }
        return Optional.empty();
    }

    private void initializeMetrics() {
        Metrics metrics = new Metrics(this, 15190);
        metrics.addCustomChart(new SingleLineChart("sent_messages", () -> this.getListener().getSentMessages()));
        metrics.addCustomChart(new SimplePie("format_count", () -> String.valueOf(this.getFormatManager().size())));
    }
}

