/*
 * Decompiled with CFR 0.152.
 */
package com.sxtanna.mc.chat;

import com.sxtanna.mc.chat.VoxChatPlugin;
import com.sxtanna.mc.chat.core.ActionManager;
import com.sxtanna.mc.chat.core.FormatManager;
import com.sxtanna.mc.chat.hook.IAFontImages;
import com.sxtanna.mc.chat.hook.Placeholders;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class VoxChat {
    static VoxChat INSTANCE;
    @NotNull
    private final VoxChatPlugin plugin;

    @NotNull
    private static VoxChat getInstance() {
        return Objects.requireNonNull(INSTANCE, "VoxChat has not be enabled yet!");
    }

    @NotNull
    public static Optional<String> find(@NotNull Player player) {
        return VoxChat.getFormatManager().list().stream().filter(name -> player.hasPermission("voxchat.format." + name)).findFirst();
    }

    public static boolean send(@NotNull String format, @NotNull Player player, @NotNull String message, @NotNull Collection<? extends CommandSender> recipients) {
        Optional<BaseComponent[]> components;
        Placeholders.Replacer replacer;
        String temp = message;
        if (VoxChat.getInstance().getPlugin().getConfig().getBoolean("options.extras.replacers.items_adder.in_message") && (replacer = IAFontImages.get()) != null) {
            temp = replacer.replace((OfflinePlayer)player, temp);
        }
        if (!(components = VoxChat.getFormatManager().prepare(format, player, temp)).isPresent()) {
            return false;
        }
        recipients.forEach(other -> other.spigot().sendMessage(player.getUniqueId(), (BaseComponent[])components.get()));
        return true;
    }

    @NotNull
    public static ActionManager getActionManager() {
        return VoxChat.getInstance().getPlugin().getActionManager();
    }

    @NotNull
    public static FormatManager getFormatManager() {
        return VoxChat.getInstance().getPlugin().getFormatManager();
    }

    @NotNull
    public static Placeholders getReplacer() {
        return VoxChat.getInstance().getPlugin().getReplacer();
    }

    VoxChat(@NotNull VoxChatPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public VoxChatPlugin getPlugin() {
        return this.plugin;
    }
}

