/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation;

import de.rapha149.voidtotem.kyori.adventure.text.format.TextDecoration;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.Transformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.TransformationFactory;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.TransformationParser;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.ClickTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.ColorTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.DecorationTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.FontTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.GradientTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.HoverTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.InsertionTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.KeybindTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.PreTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.RainbowTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.ResetTransformation;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild.TranslatableTransformation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TransformationType<T extends Transformation> {
    public static final TransformationType<?> COLOR = TransformationType.transformationType(ColorTransformation::canParse, ColorTransformation::create);
    public static final TransformationType<?> DECORATION = TransformationType.transformationType(TransformationType.acceptingNames(Stream.of(TextDecoration.NAMES.keys(), DecorationTransformation.DECORATION_ALIASES.keySet()).flatMap(Collection::stream).collect(Collectors.toSet())), DecorationTransformation::create);
    public static final TransformationType<?> HOVER_EVENT = TransformationType.transformationType(TransformationType.acceptingNames("hover"), HoverTransformation::create);
    public static final TransformationType<?> CLICK_EVENT = TransformationType.transformationType(TransformationType.acceptingNames("click"), ClickTransformation::create);
    public static final TransformationType<?> KEYBIND = TransformationType.transformationType(TransformationType.acceptingNames("key"), KeybindTransformation::create);
    public static final TransformationType<?> TRANSLATABLE = TransformationType.transformationType(TransformationType.acceptingNames("lang", "translate", "tr"), TranslatableTransformation::create);
    public static final TransformationType<?> INSERTION = TransformationType.transformationType(TransformationType.acceptingNames("insert"), InsertionTransformation::create);
    public static final TransformationType<?> FONT = TransformationType.transformationType(TransformationType.acceptingNames("font"), FontTransformation::create);
    public static final TransformationType<?> GRADIENT = TransformationType.transformationType(TransformationType.acceptingNames("gradient"), GradientTransformation::create);
    public static final TransformationType<?> RAINBOW = TransformationType.transformationType(TransformationType.acceptingNames("rainbow"), RainbowTransformation::create);
    @Deprecated
    public static final TransformationType<?> RESET = TransformationType.transformationType(TransformationType.acceptingNames("reset", "r"), ResetTransformation::create);
    @Deprecated
    public static final TransformationType<?> PRE = TransformationType.transformationType(TransformationType.acceptingNames("pre"), PreTransformation::create);
    final Predicate<String> canParse;
    final TransformationFactory<T> factory;

    @Deprecated
    public TransformationType(Predicate<String> canParse, TransformationParser<T> parser) {
        this.canParse = canParse;
        this.factory = (ctx, name, args) -> {
            Object ret = parser.parse();
            ((Transformation)ret).context(ctx);
            ((Transformation)ret).load(name, args);
            return ret;
        };
    }

    private TransformationType(Predicate<String> canParse, TransformationFactory<T> factory) {
        this.canParse = canParse;
        this.factory = factory;
    }

    public static <T extends Transformation> TransformationType<T> transformationType(Predicate<String> nameMatcher, TransformationFactory<T> factory) {
        return new TransformationType<T>(Objects.requireNonNull(nameMatcher, "nameMatcher"), Objects.requireNonNull(factory, "factory"));
    }

    public static <T extends Transformation> TransformationType<T> transformationType(Predicate<String> nameMatcher, TransformationFactory.ContextFree<T> contextFreeFactory) {
        return new TransformationType<T>(Objects.requireNonNull(nameMatcher, "nameMatcher"), Objects.requireNonNull(contextFreeFactory, "contextFreeFactory"));
    }

    public static Predicate<String> acceptingNames(String ... elements) {
        return TransformationType.acceptingNames(Arrays.asList(elements));
    }

    public static Predicate<String> acceptingNames(Collection<String> elements) {
        if (elements.size() == 1) {
            String name = elements.iterator().next().toLowerCase(Locale.ROOT);
            return tag -> tag.equals(name);
        }
        HashSet<String> names = new HashSet<String>(elements.size());
        for (String name : elements) {
            names.add(name.toLowerCase(Locale.ROOT));
        }
        return names::contains;
    }
}

