/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem.kyori.adventure.text.minimessage.parser.node;

import de.rapha149.voidtotem.kyori.adventure.text.minimessage.Template;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.parser.ParsingException;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.parser.Token;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.parser.node.ElementNode;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.parser.node.TagPart;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.template.TemplateResolver;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TagNode
extends ElementNode {
    private final List<TagPart> parts;
    @Nullable
    private Transformation transformation = null;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public TagNode(@NotNull ElementNode parent, @NotNull Token token, @NotNull String sourceMessage, @NotNull Map<String, Template> templates) {
        this(parent, token, sourceMessage, TemplateResolver.pairs(templates));
    }

    public TagNode(@NotNull ElementNode parent, @NotNull Token token, @NotNull String sourceMessage, @NotNull TemplateResolver templateResolver) {
        super(parent, token, sourceMessage);
        this.parts = TagNode.genParts(token, sourceMessage, templateResolver);
    }

    @NotNull
    private static List<TagPart> genParts(@NotNull Token token, @NotNull String sourceMessage, @NotNull TemplateResolver templateResolver) {
        ArrayList<TagPart> parts = new ArrayList<TagPart>();
        if (token.childTokens() != null) {
            for (Token childToken : token.childTokens()) {
                parts.add(new TagPart(sourceMessage, childToken, templateResolver));
            }
        }
        return parts;
    }

    @NotNull
    public List<TagPart> parts() {
        return this.parts;
    }

    @NotNull
    public String name() {
        if (this.parts.isEmpty()) {
            throw new ParsingException("Tag has no parts? " + this, this.sourceMessage(), this.token());
        }
        return this.parts.get(0).value();
    }

    @Override
    @NotNull
    public Token token() {
        return Objects.requireNonNull(super.token(), "token is not set");
    }

    @NotNull
    public Transformation transformation() {
        return Objects.requireNonNull(this.transformation, "no transformation set");
    }

    public void transformation(@NotNull Transformation transformation) {
        this.transformation = transformation;
    }

    @Override
    @NotNull
    public StringBuilder buildToString(@NotNull StringBuilder sb, int indent) {
        char[] in = this.ident(indent);
        sb.append(in).append("TagNode(");
        int size = this.parts.size();
        for (int i = 0; i < size; ++i) {
            TagPart part = this.parts.get(i);
            sb.append('\'').append(part.value()).append('\'');
            if (i == size - 1) continue;
            sb.append(", ");
        }
        sb.append(") {\n");
        for (ElementNode child : this.children()) {
            child.buildToString(sb, indent + 1);
        }
        sb.append(in).append("}\n");
        return sb;
    }
}

