/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem;

import de.rapha149.voidtotem.Config;
import de.rapha149.voidtotem.Messages;
import de.rapha149.voidtotem.VoidTotem;
import de.rapha149.voidtotem.version.VersionWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class VoidTotemCommand
implements CommandExecutor,
TabCompleter {
    public VoidTotemCommand(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("voidtotem")) {
            sender.sendMessage(Messages.getMessage("no_permission"));
            return true;
        }
        if (args.length < 1 || !args[0].toLowerCase().matches("reload|giveitem")) {
            sender.sendMessage(Messages.getMessage("syntax").replace("%syntax%", alias + " <reload|giveitem>"));
            return true;
        }
        boolean isPlayer = sender instanceof Player;
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("voidtotem.reload")) {
                    sender.sendMessage(Messages.getMessage("no_permission"));
                    break;
                }
                Messages.loadMessages();
                try {
                    if (Config.load()) {
                        sender.sendMessage(Messages.getMessage("reload.success"));
                    } else if (isPlayer) {
                        sender.sendMessage(Messages.getMessage("reload.mistakes"));
                    }
                    VoidTotem.getInstance().loadRecipe();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (!isPlayer) break;
                    sender.sendMessage(Messages.getMessage("error"));
                }
                break;
            }
            case "giveitem": {
                Player target;
                if (!sender.hasPermission("voidtotem.giveitem")) {
                    sender.sendMessage(Messages.getMessage("no_permission"));
                    break;
                }
                boolean self = false;
                if (args.length >= 2 && sender.hasPermission("voidtotem.giveitem.others")) {
                    target = Bukkit.getPlayerExact((String)args[1]);
                    if (target == null) {
                        sender.sendMessage(Messages.getMessage("player_not_found").replace("%name%", args[1]));
                        break;
                    }
                } else if (isPlayer) {
                    self = true;
                    target = (Player)sender;
                } else {
                    sender.sendMessage(Messages.getMessage("syntax").replace("%syntax%", alias + " giveitem <Player>"));
                    break;
                }
                VersionWrapper wrapper = VoidTotem.getInstance().wrapper;
                ItemStack item = Config.get().item.result.getItemStack();
                if (item == null) {
                    sender.sendMessage(Messages.getMessage("giveitem.item_not_valid"));
                    break;
                }
                String messagePrefix = "giveitem." + (self ? "self" : "others") + ".";
                PlayerInventory inventory = target.getInventory();
                if (inventory.firstEmpty() == -1) {
                    sender.sendMessage(Messages.getMessage(messagePrefix + "no_empty_slot").replace("%player%", target.getName()));
                    break;
                }
                inventory.addItem(new ItemStack[]{wrapper.addIdentifier(item)});
                sender.sendMessage(Messages.getMessage(messagePrefix + "success").replace("%player%", target.getName()));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("voidtotem")) {
            return Collections.emptyList();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("voidtotem.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("voidtotem.giveitem")) {
                completions.add("giveitem");
            }
        } else if (args.length == 2 && sender.hasPermission("voidtotem.giveitem") && args[0].equalsIgnoreCase("giveitem")) {
            Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).forEach(completions::add);
        }
        String arg = args[args.length - 1].toLowerCase();
        return completions.stream().filter(s -> s.toLowerCase().startsWith(arg)).collect(Collectors.toList());
    }
}

