/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem;

import com.google.common.collect.Streams;
import de.rapha149.voidtotem.Config;
import de.rapha149.voidtotem.Events;
import de.rapha149.voidtotem.Messages;
import de.rapha149.voidtotem.Metrics;
import de.rapha149.voidtotem.Updates;
import de.rapha149.voidtotem.VoidTotemCommand;
import de.rapha149.voidtotem.version.VersionWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public final class VoidTotem
extends JavaPlugin {
    private final NamespacedKey RECIPE_KEY = new NamespacedKey((Plugin)this, "void_totem");
    private static VoidTotem instance;
    public VersionWrapper wrapper;

    public void onEnable() {
        String version;
        instance = this;
        String nmsVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1);
        try {
            this.wrapper = (VersionWrapper)Class.forName(VersionWrapper.class.getPackage().getName() + ".Wrapper" + nmsVersion).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Failed to load support for server version \"" + nmsVersion + "\"");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("VoidTotem does not fully support the server version \"" + nmsVersion + "\"");
        }
        Messages.loadMessages();
        try {
            Config.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().severe("Failed to load config.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.loadMetrics();
        if (Config.get().checkForUpdates && (version = Updates.getAvailableVersion()) != null) {
            if (version.isEmpty()) {
                this.getLogger().info(Messages.getMessage("plugin.up_to_date"));
            } else {
                for (String line : Messages.getMessage("plugin.outdated").split("\n")) {
                    this.getLogger().warning(line.replace("%version%", version).replace("%url%", "https://www.spigotmc.org/resources/void-totem.99003/"));
                }
            }
        }
        this.loadRecipe();
        new VoidTotemCommand(this.getCommand("voidtotem"));
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        this.getLogger().info(Messages.getMessage("plugin.enable"));
    }

    public void onDisable() {
        this.getLogger().info(Messages.getMessage("plugin.disable"));
    }

    public static VoidTotem getInstance() {
        return instance;
    }

    private void loadMetrics() {
        Metrics metrics = new Metrics(this, 13802);
        metrics.addCustomChart(new Metrics.DrilldownPie("check_for_updates", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(this.getDescription().getVersion(), 1);
            map.put(String.valueOf(Config.get().checkForUpdates), entry);
            return map;
        }));
        metrics.addCustomChart(new Metrics.SimplePie("totem_statistic", () -> String.valueOf(Config.get().playerData.totemStatistic)));
        metrics.addCustomChart(new Metrics.DrilldownPie("advancement", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(Config.get().playerData.advancement.advancement, 1);
            map.put(String.valueOf(Config.get().playerData.advancement.enabled), entry);
            return map;
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("effects", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> restoreFoodLevel = new HashMap<String, Integer>();
            HashMap<String, Integer> removeExistingEffects = new HashMap<String, Integer>();
            restoreFoodLevel.put(String.valueOf(Config.get().effects.restoreFoodLevel), 1);
            removeExistingEffects.put(String.valueOf(Config.get().effects.removeExistingEffects), 1);
            map.put("Restore food level", restoreFoodLevel);
            map.put("Remove existing effects", removeExistingEffects);
            return map;
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("potion_effects", () -> {
            HashMap map = new HashMap();
            Config.get().effects.list.forEach(effect -> {
                PotionEffectType type = PotionEffectType.getByName((String)effect.name);
                if (type != null) {
                    map.put(type.getName().toLowerCase(), 1);
                }
            });
            return map;
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("animation", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> teleportParticles = new HashMap<String, Integer>();
            HashMap<String, Integer> teleportSound = new HashMap<String, Integer>();
            HashMap<String, Integer> totemEffects = new HashMap<String, Integer>();
            teleportParticles.put(String.valueOf(Config.get().animation.teleportParticles), 1);
            teleportSound.put(String.valueOf(Config.get().animation.teleportSound), 1);
            totemEffects.put(String.valueOf(Config.get().animation.totemEffects), 1);
            map.put("Teleport particles", teleportParticles);
            map.put("Teleport sound", teleportSound);
            map.put("Totem effects", totemEffects);
            return map;
        }));
        metrics.addCustomChart(new Metrics.SimplePie("item_in_hand", () -> String.valueOf(Config.get().item.hasToBeInHand)));
        metrics.addCustomChart(new Metrics.DrilldownPie("custom_recipe", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            Material mat = Material.getMaterial((String)Config.get().item.result.item.toUpperCase());
            if (mat != null) {
                entry.put(mat.toString().toLowerCase(), 1);
            }
            map.put(String.valueOf(Config.get().item.customRecipe), entry);
            return map;
        }));
    }

    public void loadRecipe() {
        this.wrapper.removeRecipe(this.RECIPE_KEY);
        if (Streams.stream((Iterator)Bukkit.recipeIterator()).anyMatch(recipe -> recipe instanceof ShapelessRecipe && ((ShapelessRecipe)recipe).getKey().equals((Object)this.RECIPE_KEY) || recipe instanceof ShapedRecipe && ((ShapedRecipe)recipe).getKey().equals((Object)this.RECIPE_KEY))) {
            this.getLogger().warning(Messages.getMessage("old_recipe_not_removed"));
            return;
        }
        Config.ItemData itemData = Config.get().item;
        if (itemData.customRecipe && itemData.result.valid && itemData.recipe.valid) {
            ItemStack result = itemData.result.getItemStack();
            Config.ItemData.RecipeData recipeData = itemData.recipe;
            if (!recipeData.shaped) {
                ShapelessRecipe recipe2 = new ShapelessRecipe(this.RECIPE_KEY, result);
                recipeData.shapelessIngredients.forEach(ingredient -> recipe2.addIngredient(Material.getMaterial((String)ingredient.toUpperCase())));
                Bukkit.addRecipe((Recipe)recipe2);
            } else {
                ShapedRecipe recipe3 = new ShapedRecipe(this.RECIPE_KEY, result);
                String[] shape = new String[recipeData.shapedIngredients.size()];
                HashMap<String, Character> ingredients = new HashMap<String, Character>();
                for (int i = 0; i < recipeData.shapedIngredients.size(); ++i) {
                    StringBuilder sb = new StringBuilder();
                    for (String str : recipeData.shapedIngredients.get(i).split("\\|")) {
                        String ingredient2 = str.trim();
                        Character character = (Character)ingredients.get(ingredient2);
                        if (character == null) {
                            for (int c2 = 97; c2 <= 122; ++c2) {
                                if (ingredients.containsValue(Character.valueOf((char)c2))) continue;
                                character = Character.valueOf((char)c2);
                                ingredients.put(ingredient2, character);
                                break;
                            }
                        }
                        if (character == null) continue;
                        sb.append(character);
                    }
                    shape[i] = sb.toString();
                }
                recipe3.shape(shape);
                ingredients.forEach((ingredient, c) -> recipe3.setIngredient(c.charValue(), Material.getMaterial((String)ingredient.toUpperCase())));
                try {
                    Bukkit.addRecipe((Recipe)recipe3);
                }
                catch (IllegalStateException e) {
                    this.getLogger().warning(Messages.getMessage("old_recipe_not_removed"));
                }
            }
        }
    }
}

