/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.inbuild;

import de.rapha149.voidtotem.kyori.adventure.text.Component;
import de.rapha149.voidtotem.kyori.adventure.text.event.ClickEvent;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.parser.ParsingException;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.parser.node.TagPart;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.transformation.Transformation;
import de.rapha149.voidtotem.kyori.examination.ExaminableProperty;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClickTransformation
extends Transformation {
    private final ClickEvent.Action action;
    private final String value;

    public static ClickTransformation create(String name, List<TagPart> args) {
        if (args.size() != 2) {
            throw new ParsingException("Don't know how to turn " + args + " into a click event", args);
        }
        @Nullable ClickEvent.Action action = ClickEvent.Action.NAMES.value(args.get(0).value().toLowerCase(Locale.ROOT));
        String value = args.get(1).value();
        if (action == null) {
            throw new ParsingException("Unknown click event action '" + args.get(0).value() + "'", args);
        }
        return new ClickTransformation(action, value);
    }

    private ClickTransformation(ClickEvent.Action action, String value) {
        this.action = action;
        this.value = value;
    }

    @Override
    public Component apply() {
        return Component.empty().clickEvent(ClickEvent.clickEvent(this.action, this.value));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", (Object)this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClickTransformation that = (ClickTransformation)other;
        return this.action == that.action && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.value});
    }
}

