/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem.kyori.adventure.text.minimessage.template;

import de.rapha149.voidtotem.kyori.adventure.text.ComponentLike;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.Template;
import de.rapha149.voidtotem.kyori.adventure.text.minimessage.template.TemplateResolver;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DynamicTemplateResolver
implements TemplateResolver {
    private final Function<String, ?> resolver;

    DynamicTemplateResolver(Function<String, ?> resolver) {
        this.resolver = resolver;
    }

    @Override
    public boolean canResolve(@NotNull String key) {
        Object result = this.resolver.apply(key);
        return result instanceof String || result instanceof ComponentLike || result instanceof Template;
    }

    @Override
    @Nullable
    public Template resolve(@NotNull String key) {
        Object result = this.resolver.apply(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return Template.template(key, (String)result);
        }
        if (result instanceof ComponentLike) {
            return Template.template(key, (ComponentLike)result);
        }
        if (result instanceof Template) {
            return (Template)result;
        }
        throw new IllegalArgumentException("Dynamic template resolver must return instances of String or ComponentLike, instead found " + result.getClass().getName());
    }
}

