/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem.version;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.rapha149.voidtotem.version.VersionWrapper;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.Recipes;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class Wrapper1_19_R1
implements VersionWrapper {
    @Override
    public boolean verifyNBT(String nbt) {
        try {
            MojangsonParser.a((String)nbt);
            return true;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    @Override
    public ItemStack applyNBT(ItemStack item, String nbt) {
        try {
            net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.v().a(MojangsonParser.a((String)nbt));
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Can't read nbt string", e);
        }
    }

    @Override
    public ItemStack addIdentifier(ItemStack item) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        nmsItem.v().a("voidtotem", true);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @Override
    public boolean hasIdentifier(ItemStack item) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!nmsItem.t()) {
            return false;
        }
        NBTTagCompound nbt = nmsItem.v();
        if (!nbt.e("voidtotem")) {
            return false;
        }
        return nbt.q("voidtotem");
    }

    @Override
    public void removeRecipe(NamespacedKey key) {
        CraftingManager manager = ((CraftServer)Bukkit.getServer()).getServer().aE();
        MinecraftKey minecraftKey = new MinecraftKey(key.getNamespace(), key.getKey());
        ((Object2ObjectLinkedOpenHashMap)manager.c.get(Recipes.a)).remove((Object)minecraftKey);
        try {
            Field field = manager.getClass().getDeclaredField("d");
            field.setAccessible(true);
            Map map = (Map)field.get(manager);
            if (!(map instanceof ImmutableMap)) {
                map.remove(minecraftKey);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getPotionEffectName(PotionEffectType type) {
        return type.getKey().getKey();
    }

    @Override
    public int getDownwardHeightLimit(World world) {
        return world.getMinHeight();
    }

    @Override
    public Block getHighestEmptyBlockAt(World world, int x, int z) {
        return world.getHighestBlockAt(x, z).getRelative(BlockFace.UP);
    }

    @Override
    public boolean isPassable(Block block) {
        return block.isPassable();
    }

    @Override
    public double getAbsorptionHearts(LivingEntity entity) {
        return entity.getAbsorptionAmount();
    }
}

