/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem.version;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.rapha149.voidtotem.version.VersionWrapper;
import java.util.Map;
import net.minecraft.server.v1_13_R2.CraftingManager;
import net.minecraft.server.v1_13_R2.MinecraftKey;
import net.minecraft.server.v1_13_R2.MojangsonParser;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_13_R2.CraftServer;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class Wrapper1_13_R2
implements VersionWrapper {
    @Override
    public boolean verifyNBT(String nbt) {
        try {
            MojangsonParser.parse((String)nbt);
            return true;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    @Override
    public ItemStack applyNBT(ItemStack item, String nbt) {
        try {
            net.minecraft.server.v1_13_R2.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.getOrCreateTag().a(MojangsonParser.parse((String)nbt));
            return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)nmsItem);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Can't read nbt string", e);
        }
    }

    @Override
    public ItemStack addIdentifier(ItemStack item) {
        net.minecraft.server.v1_13_R2.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        nmsItem.getOrCreateTag().setBoolean("voidtotem", true);
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)nmsItem);
    }

    @Override
    public boolean hasIdentifier(ItemStack item) {
        net.minecraft.server.v1_13_R2.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!nmsItem.hasTag()) {
            return false;
        }
        NBTTagCompound nbt = nmsItem.getTag();
        if (!nbt.hasKey("voidtotem")) {
            return false;
        }
        return nbt.getBoolean("voidtotem");
    }

    @Override
    public void removeRecipe(NamespacedKey key) {
        try {
            CraftingManager cm = ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager();
            ((Map)cm.getClass().getDeclaredField("recipes").get(cm)).remove(new MinecraftKey(key.getNamespace(), key.getKey()));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getPotionEffectName(PotionEffectType type) {
        return type.getName();
    }

    @Override
    public int getDownwardHeightLimit(World world) {
        return 0;
    }

    @Override
    public Block getHighestEmptyBlockAt(World world, int x, int z) {
        return world.getHighestBlockAt(x, z);
    }

    @Override
    public boolean isPassable(Block block) {
        return block.isPassable();
    }

    @Override
    public double getAbsorptionHearts(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().getAbsorptionHearts();
    }
}

