/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem;

import de.rapha149.voidtotem.VoidTotem;
import java.io.File;
import java.io.IOException;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Messages {
    private static File messageFile = new File(VoidTotem.getInstance().getDataFolder(), "messages.yml");
    private static FileConfiguration messageConfig = new YamlConfiguration();

    public static void loadMessages() {
        try {
            if (messageFile.exists()) {
                messageConfig.load(messageFile);
            } else {
                messageFile.getParentFile().mkdirs();
            }
            messageConfig.getKeys(true).forEach(key -> {
                if (!messageConfig.getDefaults().isSet(key)) {
                    messageConfig.set(key, null);
                }
            });
            messageConfig.save(messageFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            VoidTotem.getInstance().getLogger().severe("Failed to load message config.");
        }
    }

    public static String getMessage(String key) {
        if (messageConfig.contains(key)) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)messageConfig.getString(key).replace("\\n", "\n").replace("%prefix%", messageConfig.getString("prefix")));
        }
        throw new IllegalArgumentException("Message key \"" + key + "\" does not exist.");
    }

    static {
        messageConfig.options().copyDefaults(true);
        messageConfig.addDefault("prefix", (Object)"&8[&4VoidTotem&8] ");
        messageConfig.addDefault("plugin.enable", (Object)"Plugin successfully enabled.");
        messageConfig.addDefault("plugin.disable", (Object)"Plugin disabled.");
        messageConfig.addDefault("plugin.up_to_date", (Object)"Your version of this plugin is up to date!");
        messageConfig.addDefault("plugin.outdated", (Object)"There's a new version available for this plugin: %version%\nYou can download it from: %url%");
        messageConfig.addDefault("config.advancement.invalid_key", (Object)"Invalid advancement key \"%key%\"");
        messageConfig.addDefault("config.advancement.not_found", (Object)"There's no advancement with the key \"%key%\"");
        messageConfig.addDefault("config.potion_effect_not_found", (Object)"There's no potion effect with the id \"%id%\"");
        messageConfig.addDefault("config.recipe.result_item.not_found", (Object)"The result item \"%item%\" does not exist.");
        messageConfig.addDefault("config.recipe.result_item.invalid_count", (Object)"The count of the result item has to be between %limit_down% and %limit_up%.");
        messageConfig.addDefault("config.recipe.result_item.invalid_nbt", (Object)"Can't read result item nbt string.");
        messageConfig.addDefault("config.recipe.shapeless_ingredients_invalid_count", (Object)"You specified an invalid amount of ingredients.");
        messageConfig.addDefault("config.recipe.shaped.ingredient_rows_invalid_count", (Object)"You specified an invalid amount of ingredient rows.");
        messageConfig.addDefault("config.recipe.shaped.ingredients_invalid_count", (Object)"Row %row% has an invalid amount of ingredients.");
        messageConfig.addDefault("config.recipe.ingredient_item_invalid", (Object)"The ingredient item \"%item%\" does not exist.");
        messageConfig.addDefault("old_recipe_not_removed", (Object)"The old recipe could not be removed. If you changed the recipe, please restart the server for the changed to take affect.");
        messageConfig.addDefault("error", (Object)"%prefix%&cAn error occured. Check the console for details.");
        messageConfig.addDefault("syntax", (Object)"%prefix%&cSyntax error! Please use &7/%syntax%&c.");
        messageConfig.addDefault("no_permission", (Object)"%prefix%&cYou do not have enough permissions to perform this action.");
        messageConfig.addDefault("player_not_found", (Object)"%prefix%&cThere's no player with the name &7%name%&c.");
        messageConfig.addDefault("reload.mistakes", (Object)"%prefix%&6You made some mistakes in the config, check the console for details.");
        messageConfig.addDefault("reload.success", (Object)"%prefix%&7Config was reloaded.");
        messageConfig.addDefault("giveitem.item_not_valid", (Object)"%prefix%&cThe result item in the config is not valid.");
        messageConfig.addDefault("giveitem.self.no_empty_slot", (Object)"%prefix%&cYou have no empty slot in your inventory.");
        messageConfig.addDefault("giveitem.self.success", (Object)"%prefix%&7A void totem item was given to you.");
        messageConfig.addDefault("giveitem.others.no_empty_slot", (Object)"%prefix%&7%player% &chas no empty slot in your inventory.");
        messageConfig.addDefault("giveitem.others.success", (Object)"%prefix%&7A void totem item was given to &6%player%&7.");
    }
}

