/*
 * Decompiled with CFR 0.152.
 */
package de.rapha149.voidtotem;

import de.rapha149.voidtotem.Config;
import de.rapha149.voidtotem.VoidTotem;
import de.rapha149.voidtotem.version.VersionWrapper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Events
implements Listener {
    private Map<Long, Map.Entry<Entity, Location>> teleports = new HashMap<Long, Map.Entry<Entity, Location>>();

    @EventHandler(ignoreCancelled=true)
    public void onResurrect(EntityResurrectEvent event) {
        Config config = Config.get();
        if (!config.item.customRecipe || !config.item.noNormalResurrection) {
            return;
        }
        VersionWrapper wrapper = VoidTotem.getInstance().wrapper;
        LivingEntity entity = event.getEntity();
        EntityEquipment equipment = entity.getEquipment();
        ItemStack mainHandItem = equipment.getItemInMainHand();
        ItemStack offHandItem = equipment.getItemInOffHand();
        boolean mainHandNormal = mainHandItem.getType() == Material.TOTEM_OF_UNDYING;
        boolean offHandNormal = offHandItem.getType() == Material.TOTEM_OF_UNDYING;
        boolean mainHandCustom = wrapper.hasIdentifier(mainHandItem);
        boolean offHandCustom = wrapper.hasIdentifier(offHandItem);
        if (!mainHandCustom && !offHandCustom) {
            return;
        }
        if (mainHandCustom && !offHandNormal || offHandCustom && !mainHandNormal) {
            event.setCancelled(true);
            return;
        }
        if (mainHandCustom && offHandNormal) {
            equipment.setItemInOffHand(null);
            ItemStack item = mainHandItem.clone();
            Bukkit.getScheduler().runTask((Plugin)VoidTotem.getInstance(), () -> equipment.setItemInMainHand(item));
        }
    }

    @EventHandler
    public void onVoidDamage(EntityDamageEvent event) {
        PlayerInventory inv;
        Config config = Config.get();
        boolean isPlayer = event.getEntity() instanceof Player;
        if (event.getCause() != EntityDamageEvent.DamageCause.VOID || !(event.getEntity() instanceof LivingEntity) || config.onlySavePlayers && !isPlayer) {
            return;
        }
        LivingEntity entity = (LivingEntity)event.getEntity();
        Player player = isPlayer ? (Player)entity : null;
        VersionWrapper wrapper = VoidTotem.getInstance().wrapper;
        double health = entity.getHealth() + wrapper.getAbsorptionHearts(entity) - event.getDamage();
        if (health > config.healthTrigger) {
            return;
        }
        if (config.patchKillCommand && entity.getLocation().getY() >= (double)wrapper.getDownwardHeightLimit(entity.getWorld())) {
            return;
        }
        ItemStack usedItem = null;
        Boolean mainHand = null;
        EntityEquipment equipment = entity.getEquipment();
        PlayerInventory playerInventory = inv = isPlayer ? player.getInventory() : null;
        if (config.item.customRecipe) {
            if (!config.item.result.valid) {
                return;
            }
            if (config.item.hasToBeInHand || !isPlayer) {
                mainHand = wrapper.hasIdentifier(equipment.getItemInMainHand());
                if (!mainHand.booleanValue() && !wrapper.hasIdentifier(equipment.getItemInOffHand())) {
                    return;
                }
                usedItem = mainHand != false ? equipment.getItemInMainHand() : equipment.getItemInOffHand();
            } else {
                for (int i = 0; i < inv.getSize(); ++i) {
                    ItemStack item = inv.getItem(i);
                    if (item == null || !wrapper.hasIdentifier(item)) continue;
                    usedItem = item;
                    break;
                }
                if (usedItem == null) {
                    return;
                }
            }
        } else {
            Material mat = Material.TOTEM_OF_UNDYING;
            if (config.item.hasToBeInHand || !isPlayer) {
                mainHand = equipment.getItemInMainHand().getType() == mat;
                if (!mainHand.booleanValue() && equipment.getItemInOffHand().getType() != mat) {
                    return;
                }
                usedItem = mainHand != false ? equipment.getItemInMainHand() : equipment.getItemInOffHand();
            } else {
                for (int i = 0; i < inv.getSize(); ++i) {
                    ItemStack item = inv.getItem(i);
                    if (item == null || item.getType() != mat) continue;
                    usedItem = item;
                    break;
                }
                if (usedItem == null) {
                    return;
                }
            }
        }
        Location loc = entity.getLocation();
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        ArrayList distances = new ArrayList();
        if (config.randomization.enabled && config.randomization.distanceStack > 0) {
            int i;
            if (config.randomization.distanceStack > 1) {
                ArrayList<Integer> distanceStack = new ArrayList<Integer>();
                for (i = 0; i < config.searchDistance; ++i) {
                    distanceStack.add(i);
                    if (distanceStack.size() < config.randomization.distanceStack && i + 1 < config.searchDistance && (config.randomization.randomizeZeroDistance || i != 0)) continue;
                    Collections.shuffle(distanceStack);
                    distances.addAll(distanceStack);
                    distanceStack.clear();
                }
            } else {
                boolean randomizeZero = config.randomization.randomizeZeroDistance;
                int n = i = randomizeZero ? 0 : 1;
                while (i < config.searchDistance) {
                    distances.add(i);
                    ++i;
                }
                Collections.shuffle(distances);
                if (!randomizeZero) {
                    distances.add(0, 0);
                }
            }
        } else {
            for (int i = 0; i < config.searchDistance; ++i) {
                distances.add(i);
            }
        }
        for (Integer distance : distances) {
            boolean found = false;
            ArrayList<int[]> blocks = new ArrayList<int[]>();
            if (distance > 0) {
                int x1 = x - distance;
                int z1 = z - distance;
                int x2 = x + distance;
                int z2 = z + distance;
                int cX = x1;
                int cZ = z1;
                while (cX < x2) {
                    blocks.add(new int[]{cX++, cZ});
                }
                while (cZ < z2) {
                    blocks.add(new int[]{cX, cZ++});
                }
                while (cX > x1) {
                    blocks.add(new int[]{cX--, cZ});
                }
                while (cZ > z1) {
                    blocks.add(new int[]{cX, cZ--});
                }
                if (config.randomization.enabled) {
                    Collections.shuffle(blocks);
                }
            } else {
                blocks.add(new int[]{x, z});
            }
            for (int[] coords : blocks) {
                boolean removeExisting;
                Block block = wrapper.getHighestEmptyBlockAt(world, coords[0], coords[1]);
                if (!block.getRelative(BlockFace.DOWN).getType().isSolid() || !wrapper.isPassable(block) || !wrapper.isPassable(block.getRelative(BlockFace.UP))) continue;
                Location newLoc = block.getLocation().add(0.5, 0.0, 0.5);
                newLoc.setYaw(entity.getLocation().getYaw());
                newLoc.setPitch(entity.getLocation().getPitch());
                event.setCancelled(true);
                if (!isPlayer || player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE) {
                    usedItem.setAmount(usedItem.getAmount() - 1);
                    if (isPlayer) {
                        player.updateInventory();
                    } else if (mainHand.booleanValue()) {
                        equipment.setItemInMainHand(usedItem);
                    } else {
                        equipment.setItemInOffHand(usedItem);
                    }
                }
                List effectIds = (removeExisting = config.effects.removeExistingEffects) ? null : config.effects.list.stream().map(effectData -> effectData.id).collect(Collectors.toList());
                entity.getActivePotionEffects().forEach(effect -> {
                    if (removeExisting || effectIds.contains(effect.getType().getId())) {
                        entity.removePotionEffect(effect.getType());
                    }
                });
                entity.setGliding(false);
                entity.setFallDistance(0.0f);
                if (config.forceTeleport) {
                    long time = System.currentTimeMillis();
                    this.teleports.put(time, new AbstractMap.SimpleEntry<LivingEntity, Location>(entity, newLoc));
                    Bukkit.getScheduler().runTaskLater((Plugin)VoidTotem.getInstance(), () -> this.teleports.remove(time), 5L);
                }
                entity.teleport(newLoc);
                entity.setHealth(Math.min(Math.max(health, 0.0) + 0.5, 20.0));
                entity.addPotionEffects((Collection)config.effects.list.stream().map(effectData -> {
                    PotionEffectType type = PotionEffectType.getById((int)effectData.id);
                    return type != null ? new PotionEffect(type, effectData.duration * 20, effectData.amplifier) : null;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
                if (isPlayer) {
                    AdvancementProgress progress;
                    Advancement advancement;
                    if (config.effects.restoreFoodLevel) {
                        player.setFoodLevel(20);
                        player.setSaturation(20.0f);
                        player.setExhaustion(0.0f);
                    }
                    if (config.playerData.totemStatistic) {
                        player.incrementStatistic(Statistic.USE_ITEM, Material.TOTEM_OF_UNDYING);
                    }
                    Config.PlayerData.AdvancementData advancementData = config.playerData.advancement;
                    if (advancementData.enabled && advancementData.valid && (advancement = Bukkit.getAdvancement((NamespacedKey)advancementData.key)) != null && !(progress = player.getAdvancementProgress(advancement)).isDone()) {
                        List<String> criteria = advancementData.criteria;
                        progress.getRemainingCriteria().stream().filter(criterion -> criteria.isEmpty() || criteria.contains(criterion)).forEach(arg_0 -> ((AdvancementProgress)progress).awardCriteria(arg_0));
                    }
                }
                Runnable totemEffects = () -> {
                    if (config.animation.totemEffects) {
                        entity.playEffect(EntityEffect.TOTEM_RESURRECT);
                    }
                };
                Bukkit.getScheduler().runTask((Plugin)VoidTotem.getInstance(), () -> {
                    if (config.animation.teleportParticles) {
                        world.spawnParticle(Particle.PORTAL, newLoc.clone().add(0.0, 1.0, 0.0), 150, 0.3, 0.4, 0.3, 0.1);
                    }
                    if (config.animation.teleportSound) {
                        world.playSound(newLoc, Sound.ITEM_CHORUS_FRUIT_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        Bukkit.getScheduler().runTaskLater((Plugin)VoidTotem.getInstance(), totemEffects, 6L);
                    } else {
                        totemEffects.run();
                    }
                });
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTeleport(EntityTeleportEvent event) {
        this.onTeleport((Cancellable)event, event.getEntity(), event.getTo());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.PLUGIN) {
            return;
        }
        this.onTeleport((Cancellable)event, (Entity)event.getPlayer(), event.getTo());
    }

    private void onTeleport(Cancellable event, Entity entity, Location loc) {
        if (!Config.get().forceTeleport) {
            return;
        }
        this.teleports.values().removeIf(entry -> {
            if (((Entity)entry.getKey()).equals(entity) && ((Location)entry.getValue()).equals((Object)loc)) {
                event.setCancelled(false);
                return true;
            }
            return false;
        });
    }
}

