/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_19_R1.gameplay.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.season.SeasonAPI;
import me.nologic.vivaldi.v1_19_R1.gameplay.GameplayManager;
import me.nologic.vivaldi.v1_19_R1.gameplay.feature.AbstractGameplayFeature;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Snow;
import org.bukkit.plugin.Plugin;

public class ImprovedSnowfallFeature
extends AbstractGameplayFeature {
    private final int iterations;
    private final BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private final int maxSnowLayers = this.plugin.getConfig().getInt("gameplay-settings.features." + this.name + ".max-snow-layers");
    private final boolean adjustSnowLayersIsEnabled = this.plugin.getConfig().getBoolean("gameplay-settings.features." + this.name + ".adjust-snow-layers");

    public ImprovedSnowfallFeature(GameplayManager gameplayManager) {
        super(gameplayManager, "improved-snowfall");
        this.iterations = this.plugin.getConfig().getInt("gameplay-settings.features." + this.name + ".blocks-per-cycle");
    }

    @Override
    public void run() {
        while (!this.isCancelled) {
            if (SeasonAPI.getInstance().getCurrentSeason() == Season.WINTER && this.world.isThundering() || this.world.hasStorm()) {
                List<Chunk> chunks = Arrays.asList(this.world.getLoadedChunks());
                Collections.shuffle(chunks);
                chunks.forEach(chunk -> this.place(this.snow((Chunk)chunk)));
            }
            try {
                ImprovedSnowfallFeature.sleep(this.pauseBetweenIterations);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    private List<Block> snow(Chunk chunk) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < this.iterations; ++i) {
            Block block = this.world.getHighestBlockAt(chunk.getBlock(this.random.nextInt(16), 0, this.random.nextInt(16)).getLocation(), HeightMap.MOTION_BLOCKING);
            if (block.getTemperature() > 0.15) continue;
            if (block.getType().toString().toLowerCase().contains("leaves")) {
                if (block.getRelative(BlockFace.UP).getType() == Material.AIR) {
                    blocks.add(block.getRelative(BlockFace.UP));
                }
                Block blockUnderLeaves = this.world.getHighestBlockAt(block.getLocation(), HeightMap.MOTION_BLOCKING_NO_LEAVES);
                switch (blockUnderLeaves.getType()) {
                    case GRASS_BLOCK: 
                    case DIRT: 
                    case COARSE_DIRT: 
                    case PODZOL: 
                    case STONE: 
                    case COBBLESTONE: 
                    case SAND: {
                        switch (blockUnderLeaves.getRelative(BlockFace.UP).getType()) {
                            case AIR: 
                            case GRASS: 
                            case TALL_GRASS: 
                            case FERN: 
                            case LARGE_FERN: 
                            case DANDELION: 
                            case POPPY: 
                            case BLUE_ORCHID: 
                            case ALLIUM: 
                            case AZURE_BLUET: 
                            case RED_TULIP: 
                            case ORANGE_TULIP: 
                            case PINK_TULIP: 
                            case WHITE_TULIP: 
                            case OXEYE_DAISY: 
                            case CORNFLOWER: 
                            case LILY_OF_THE_VALLEY: 
                            case SUNFLOWER: 
                            case LILAC: 
                            case ROSE_BUSH: 
                            case PEONY: {
                                blocks.add(blockUnderLeaves.getRelative(BlockFace.UP));
                            }
                        }
                    }
                }
            }
            switch (block.getType()) {
                case GRASS_BLOCK: 
                case DIRT: 
                case PODZOL: 
                case STONE: 
                case COBBLESTONE: 
                case SAND: 
                case MYCELIUM: {
                    switch (block.getRelative(BlockFace.UP).getType()) {
                        case AIR: 
                        case GRASS: 
                        case TALL_GRASS: 
                        case FERN: 
                        case LARGE_FERN: 
                        case DANDELION: 
                        case POPPY: 
                        case BLUE_ORCHID: 
                        case ALLIUM: 
                        case AZURE_BLUET: 
                        case RED_TULIP: 
                        case ORANGE_TULIP: 
                        case PINK_TULIP: 
                        case WHITE_TULIP: 
                        case OXEYE_DAISY: 
                        case CORNFLOWER: 
                        case LILY_OF_THE_VALLEY: 
                        case SUNFLOWER: 
                        case LILAC: 
                        case ROSE_BUSH: 
                        case PEONY: 
                        case SNOW: {
                            blocks.add(block.getRelative(BlockFace.UP));
                        }
                    }
                }
            }
        }
        return blocks;
    }

    private void place(List<Block> blocks) {
        Bukkit.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Block block : blocks) {
                switch (block.getType()) {
                    case AIR: 
                    case GRASS: 
                    case FERN: 
                    case DANDELION: 
                    case POPPY: 
                    case BLUE_ORCHID: 
                    case ALLIUM: 
                    case AZURE_BLUET: 
                    case RED_TULIP: 
                    case ORANGE_TULIP: 
                    case PINK_TULIP: 
                    case WHITE_TULIP: 
                    case OXEYE_DAISY: 
                    case CORNFLOWER: 
                    case LILY_OF_THE_VALLEY: {
                        block.setType(Material.SNOW);
                        break;
                    }
                    case TALL_GRASS: 
                    case LARGE_FERN: 
                    case SUNFLOWER: 
                    case LILAC: 
                    case ROSE_BUSH: 
                    case PEONY: {
                        block.setType(Material.SNOW);
                        block.getRelative(BlockFace.UP).setType(Material.AIR);
                        break;
                    }
                    case SNOW: {
                        if (!this.adjustSnowLayersIsEnabled) break;
                        this.adjustSnowLayer(block.getLocation());
                    }
                }
            }
        });
    }

    private void adjustSnowLayer(Location location) {
        BlockFace[] blockFaceArray = location.getBlock().getBlockData();
        if (blockFaceArray instanceof Snow) {
            Snow snow = (Snow)blockFaceArray;
            if (snow.getLayers() < this.maxSnowLayers) {
                snow.setLayers(snow.getLayers() + 1);
            }
            if (snow.getLayers() <= this.maxSnowLayers) {
                block5: for (BlockFace face : this.faces) {
                    switch (location.getBlock().getRelative(face).getType()) {
                        case GRASS_BLOCK: 
                        case DIRT: 
                        case PODZOL: 
                        case STONE: 
                        case COBBLESTONE: 
                        case SAND: {
                            try {
                                snow.setLayers(snow.getLayers() + 2);
                                continue block5;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            location.getBlock().setBlockData((BlockData)snow);
        }
    }
}

