/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.gameplay.feature;

import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.season.SeasonAPI;
import me.nologic.vivaldi.v1_18_R2.gameplay.GameplayManager;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.AbstractGameplayFeature;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntitySnowman;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

public class SeasonalMobspawnFeature
extends AbstractGameplayFeature
implements Listener {
    public SeasonalMobspawnFeature(GameplayManager gameplayManager) {
        super(gameplayManager, "seasonal-mobspawn");
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void run() {
        while (!this.isCancelled) {
            this.spawn();
            try {
                Thread.sleep(this.pauseBetweenIterations);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    private void spawn() {
        int chance = this.plugin.getConfig().getInt("gameplay-settings.features." + this.name + ".spawn-chance");
        if (this.random.nextInt(100) < chance) {
            Location spawnLocation = this.findSpawnLocation();
            EntityType entityType = this.getRandomEntityType();
            if (spawnLocation == null) {
                return;
            }
            Bukkit.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                Entity entity = ((CraftEntity)this.world.spawnEntity(spawnLocation, entityType)).getHandle();
                switch (entityType) {
                    case FOX: {
                        ((EntityFox)entity).a(EntityFox.Type.b);
                        break;
                    }
                    case CAT: {
                        ((EntityCat)entity).s(15);
                        break;
                    }
                    case SNOWMAN: {
                        ((EntitySnowman)entity).v(false);
                    }
                }
            });
        }
    }

    private Location findSpawnLocation() {
        Chunk[] chunks = this.world.getLoadedChunks();
        if (chunks.length == 0) {
            return null;
        }
        Chunk chunk = this.world.getLoadedChunks()[this.random.nextInt(chunks.length)];
        Block block = this.world.getHighestBlockAt(chunk.getBlock(this.random.nextInt(15), 0, this.random.nextInt(15)).getLocation(), HeightMap.MOTION_BLOCKING_NO_LEAVES);
        if (block.getType() == Material.WATER) {
            return null;
        }
        Block relative = block.getRelative(BlockFace.UP);
        return switch (relative.getType()) {
            case Material.AIR, Material.GRASS, Material.SNOW -> relative.getLocation();
            default -> null;
        };
    }

    private EntityType getRandomEntityType() {
        int dice = this.random.nextInt(20);
        switch (SeasonAPI.getInstance().getCurrentSeason()) {
            case WINTER: {
                if (dice > 14) {
                    return EntityType.SNOWMAN;
                }
                if (dice > 7) {
                    return EntityType.FOX;
                }
                return EntityType.GOAT;
            }
            case SUMMER: {
                if (dice > 10) {
                    return EntityType.RABBIT;
                }
                return EntityType.PANDA;
            }
            case AUTUMN: {
                if (dice > 10) {
                    return EntityType.CAT;
                }
                return EntityType.BAT;
            }
            case SPRING: {
                if (dice > 10) {
                    return EntityType.BEE;
                }
                return EntityType.PARROT;
            }
        }
        return EntityType.WOLF;
    }

    @EventHandler
    private void onSkeletonSpawn(CreatureSpawnEvent event) {
        if (SeasonAPI.getInstance().getCurrentSeason() == Season.WINTER && event.getEntity() instanceof Skeleton && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL) {
            event.setCancelled(true);
            this.world.spawnEntity(event.getLocation(), EntityType.STRAY);
        }
    }
}

