/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.gameplay.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.season.SeasonAPI;
import me.nologic.vivaldi.v1_18_R2.gameplay.GameplayManager;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.AbstractGameplayFeature;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MeltingSimulationFeature
extends AbstractGameplayFeature {
    private final int iterations;
    private BukkitTask task;

    public MeltingSimulationFeature(GameplayManager gameplayManager) {
        super(gameplayManager, "melting-simulation");
        this.iterations = this.plugin.getConfig().getInt("gameplay-settings.features." + this.name + ".blocks-per-cycle");
    }

    @Override
    public void run() {
        this.task = Bukkit.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (this.isCancelled) {
                this.task.cancel();
                return;
            }
            if (SeasonAPI.getInstance().getCurrentSeason() == Season.WINTER) {
                return;
            }
            List<Chunk> chunks = Arrays.asList(this.world.getLoadedChunks());
            chunks.forEach(c -> this.thaw((Chunk)c, this.iterations));
        }, 0L, (long)this.pauseBetweenIterations);
    }

    private void thaw(Chunk chunk, int iterations) {
        int i = iterations;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = 0; x < 16; ++x) {
            block8: for (int z = 0; z < 16; ++z) {
                Block block = this.world.getHighestBlockAt(chunk.getBlock(x, 0, z).getLocation(), HeightMap.MOTION_BLOCKING).getRelative(BlockFace.UP);
                if (block.getType() == Material.SNOW && block.getTemperature() > 0.15) {
                    blocks.add(block);
                } else if (block.getRelative(BlockFace.DOWN).getType() == Material.ICE && block.getRelative(BlockFace.DOWN).getTemperature() > 0.15) {
                    blocks.add(block.getRelative(BlockFace.DOWN));
                }
                switch (block.getRelative(BlockFace.DOWN).getType()) {
                    case BIRCH_LEAVES: 
                    case ACACIA_LEAVES: 
                    case AZALEA_LEAVES: 
                    case DARK_OAK_LEAVES: 
                    case FLOWERING_AZALEA_LEAVES: 
                    case JUNGLE_LEAVES: 
                    case OAK_LEAVES: 
                    case SPRUCE_LEAVES: {
                        Block leaves = this.world.getHighestBlockAt(chunk.getBlock(x, 0, z).getLocation(), HeightMap.MOTION_BLOCKING_NO_LEAVES).getRelative(BlockFace.UP);
                        if (leaves.getType() != Material.SNOW) continue block8;
                        blocks.add(leaves);
                    }
                }
            }
        }
        Collections.shuffle(blocks, this.random);
        for (Block b : blocks) {
            if (i != 0) {
                switch (b.getType()) {
                    case SNOW: {
                        if (b.getRelative(BlockFace.DOWN).getType() == Material.DIRT) {
                            b.getRelative(BlockFace.DOWN).setType(Material.GRASS_BLOCK);
                        }
                        b.setType(Material.AIR);
                        break;
                    }
                    case ICE: {
                        b.setType(Material.WATER);
                    }
                }
                --i;
                continue;
            }
            return;
        }
    }
}

