/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.gameplay.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.season.SeasonAPI;
import me.nologic.vivaldi.v1_18_R2.gameplay.GameplayManager;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.AbstractGameplayFeature;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.biome.BiomeBase;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LivingNatureFeature
extends AbstractGameplayFeature {
    private final JavaPlugin plugin;
    private final GameplayManager gm;
    private final SeasonAPI sm;
    private final int flowerSpawnChance;
    private final IRegistryWritable<BiomeBase> registry;
    private final Map<Season, Map<String, List<Material>>> flowerMap;

    public LivingNatureFeature(GameplayManager gameplayManager, HashMap<Season, Map<String, List<Material>>> flowerMap) {
        super(gameplayManager, "living-nature");
        this.plugin = gameplayManager.getPlugin();
        this.gm = gameplayManager;
        this.sm = SeasonAPI.getInstance();
        this.flowerSpawnChance = this.plugin.getConfig().getInt("gameplay-settings.features." + this.name + ".flower-chance");
        this.registry = (IRegistryWritable)((CraftServer)Bukkit.getServer()).getServer().aU().b(IRegistry.aP);
        this.flowerMap = flowerMap;
    }

    @Override
    public void run() {
        int iterations = this.plugin.getConfig().getInt("gameplay-settings.features." + this.name + ".plants-per-cycle");
        while (!this.isCancelled) {
            this.prepareGrowth(iterations);
            try {
                LivingNatureFeature.sleep(this.pauseBetweenIterations);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    public void prepareGrowth(int iterations) {
        if (this.sm.getCurrentSeason() == Season.WINTER) {
            return;
        }
        List<Chunk> chunks = Arrays.asList(this.world.getLoadedChunks());
        Collections.shuffle(chunks);
        ArrayList<Block> plants = new ArrayList<Block>();
        for (Chunk chunk : chunks) {
            if (plants.size() == iterations) break;
            Block block = this.world.getHighestBlockAt(chunk.getBlock(this.random.nextInt(15), 0, this.random.nextInt(15)).getLocation(), HeightMap.MOTION_BLOCKING_NO_LEAVES);
            switch (block.getType()) {
                case GRASS_BLOCK: 
                case PODZOL: 
                case DIRT: 
                case COARSE_DIRT: {
                    Block relative = block.getRelative(BlockFace.UP);
                    switch (relative.getType()) {
                        case AIR: 
                        case SNOW: {
                            plants.add(relative);
                        }
                    }
                }
            }
        }
        this.grow(plants);
    }

    public void grow(List<Block> blocks) {
        Collections.shuffle(blocks);
        for (Block block : blocks) {
            Material flower = this.random.nextInt(100) <= this.flowerSpawnChance ? this.getRandomFlower(this.sm.getCurrentSeason(), this.getKeyedBiome(block)) : this.getRandomGrass();
            Bukkit.getServer().getScheduler().runTask((Plugin)this.gm.getPlugin(), () -> {
                if (flower == Material.TALL_GRASS) {
                    Block blockAbove = block.getRelative(BlockFace.UP);
                    if (blockAbove.getType() == Material.AIR) {
                        block.setType(Material.TALL_GRASS, false);
                        blockAbove.setType(Material.TALL_GRASS, false);
                        BlockData data = blockAbove.getBlockData();
                        ((Bisected)data).setHalf(Bisected.Half.TOP);
                        blockAbove.setBlockData(data);
                        if (block.getRelative(BlockFace.DOWN).getType() == Material.GRASS_BLOCK) {
                            block.getRelative(BlockFace.DOWN).setType(Material.GRASS_BLOCK);
                        }
                    }
                } else if (flower != null) {
                    block.setType(flower);
                }
            });
        }
    }

    private String getKeyedBiome(Block block) {
        GeneratorAccess levelAccessor = ((CraftBlock)block).getHandle();
        Holder holder = levelAccessor.v(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        return Objects.requireNonNull(this.registry.b((Object)((BiomeBase)holder.a()))).b() + ":" + Objects.requireNonNull(this.registry.b((Object)((BiomeBase)holder.a()))).a();
    }

    public Material getRandomFlower(Season season, String biome) {
        if (this.flowerMap.get((Object)season).containsKey(biome)) {
            List<Material> materials = this.flowerMap.get((Object)season).get(biome);
            return this.flowerMap.get((Object)season).get(biome).get(this.random.nextInt(materials.size()));
        }
        return null;
    }

    public Material getRandomGrass() {
        int roll = this.random.nextInt(100);
        if (roll > 85) {
            return Material.TALL_GRASS;
        }
        if (roll > 70) {
            return Material.FERN;
        }
        return Material.GRASS;
    }
}

