/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.gameplay.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.nologic.vivaldi.v1_18_R2.gameplay.GameplayManager;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.AbstractGameplayFeature;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;

public class BirchLeavesReplacerFeature
extends AbstractGameplayFeature {
    public BirchLeavesReplacerFeature(GameplayManager gameplayManager) {
        super(gameplayManager, "birch-leaves-replacer");
    }

    @Override
    public void run() {
        while (!this.isCancelled) {
            List<Chunk> chunks = Arrays.asList(this.world.getLoadedChunks());
            chunks.forEach(this::replace);
            try {
                BirchLeavesReplacerFeature.sleep(this.pauseBetweenIterations);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    private void replace(Chunk chunk) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Block block = this.world.getHighestBlockAt(chunk.getBlock(x, 0, z).getLocation(), HeightMap.MOTION_BLOCKING);
                for (int y = 0; y != 15; ++y) {
                    Block b = block.getRelative(BlockFace.DOWN, y);
                    if (b.getType() != Material.BIRCH_LEAVES) continue;
                    blocks.add(b);
                }
            }
        }
        Bukkit.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Block b : blocks) {
                b.setType(Material.ACACIA_LEAVES);
            }
        });
    }
}

