/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.gameplay.feature;

import java.util.Objects;
import java.util.Random;
import me.nologic.vivaldi.v1_18_R2.gameplay.GameplayManager;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractGameplayFeature
extends Thread {
    protected final JavaPlugin plugin;
    protected final GameplayManager manager;
    protected final World world;
    protected final String name;
    protected final int pauseBetweenIterations;
    protected final Random random;
    public boolean isEnabled;
    public boolean isCancelled;

    protected AbstractGameplayFeature(GameplayManager manager, String name) {
        this.manager = manager;
        this.plugin = manager.getPlugin();
        this.world = manager.getWorld();
        this.name = name;
        this.pauseBetweenIterations = manager.getPlugin().getConfig().getInt("gameplay-settings.features." + this.name + ".pause-between-iterations");
        this.random = new Random();
        this.isEnabled = manager.getPlugin().getConfig().getBoolean("gameplay-settings.features." + this.name + ".enabled");
        if (this.isEnabled && !Objects.equals(name, "chunk-scanner")) {
            manager.getPlugin().getLogger().info("Feature is enabled: " + this.name);
        }
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }
}

