/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.gameplay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.nologic.vivaldi.base.AbstractGameplayManager;
import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.AbstractGameplayFeature;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.BirchLeavesReplacerFeature;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.CommonDownfallFeature;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.ImprovedSnowfallFeature;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.LivingNatureFeature;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.MeltingSimulationFeature;
import me.nologic.vivaldi.v1_18_R2.gameplay.feature.SeasonalMobspawnFeature;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;

public final class GameplayManager
extends AbstractGameplayManager {
    private final JavaPlugin plugin;
    private static GameplayManager instance;
    private World world;
    private final HashMap<Season, Map<String, List<Material>>> flowerMap;
    private final List<AbstractGameplayFeature> features;

    public GameplayManager(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.features = new ArrayList<AbstractGameplayFeature>();
        this.flowerMap = new HashMap();
        for (Season season : Season.values()) {
            this.flowerMap.put(season, new HashMap());
        }
    }

    @Override
    public void enable(World world) {
        this.world = world;
        Collections.addAll(this.features, new LivingNatureFeature(this, this.flowerMap), new BirchLeavesReplacerFeature(this), new MeltingSimulationFeature(this), new ImprovedSnowfallFeature(this), new CommonDownfallFeature(this), new SeasonalMobspawnFeature(this));
        this.features.forEach(f -> {
            if (f.isEnabled) {
                f.start();
            }
        });
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public World getWorld() {
        return this.world;
    }

    public void insertToFlowerMap(Season season, String tag, Material material) {
        if (!this.flowerMap.get((Object)season).containsKey(tag)) {
            this.flowerMap.get((Object)season).put(tag, new ArrayList());
            this.flowerMap.get((Object)season).get(tag).add(material);
        } else {
            this.flowerMap.get((Object)season).get(tag).add(material);
        }
    }

    @Override
    public void disable() {
        this.features.forEach(f -> f.setCancelled(true));
    }

    public static GameplayManager getInstance() {
        return instance;
    }
}

