/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.chunk;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import me.nologic.vivaldi.base.AbstractPacketInjector;
import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.season.SeasonAPI;
import me.nologic.vivaldi.season.event.SeasonChangeEvent;
import me.nologic.vivaldi.v1_18_R2.biome.BiomeContainer;
import me.nologic.vivaldi.v1_18_R2.biome.VivaldiBiomeFactory;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.ChunkSection;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VivaldiPacketInjector
extends AbstractPacketInjector
implements Listener {
    private JavaPlugin plugin;
    private IRegistryWritable<BiomeBase> registry;
    private ChunkDatabase database;
    private World world;

    @Override
    public void enable(JavaPlugin plugin, World world) {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
        this.registry = (IRegistryWritable)((CraftServer)Bukkit.getServer()).getServer().aU().b(IRegistry.aP);
        this.database = new ChunkDatabase(plugin);
        this.world = world;
        this.database.load();
    }

    @EventHandler
    private void onPlayerJoin(PlayerJoinEvent event) {
        this.injectPlayer(event.getPlayer());
    }

    @EventHandler
    private void onPlayerQuit(PlayerQuitEvent event) {
        this.removePlayer(event.getPlayer());
    }

    private void injectPlayer(final Player player) {
        ChannelDuplexHandler channelDuplexHandler = new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext channelHandlerContext, Object packet) throws Exception {
                super.channelRead(channelHandlerContext, packet);
            }

            public void write(ChannelHandlerContext channelHandlerContext, Object packet, ChannelPromise channelPromise) throws Exception {
                Object object = packet;
                if (object instanceof ClientboundLevelChunkWithLightPacket) {
                    ClientboundLevelChunkWithLightPacket chunkPacket = (ClientboundLevelChunkWithLightPacket)object;
                    net.minecraft.world.level.chunk.Chunk levelChunk = ((CraftChunk)player.getWorld().getChunkAt(chunkPacket.b(), chunkPacket.c())).getHandle();
                    Season seasonInChunk = VivaldiPacketInjector.this.database.getSeasonOrNull(levelChunk.bukkitChunk);
                    if (seasonInChunk == null || seasonInChunk != SeasonAPI.getInstance().getCurrentSeason()) {
                        VivaldiPacketInjector.this.database.write(levelChunk.getBukkitChunk());
                        VivaldiPacketInjector.this.changeBiomes(levelChunk);
                        packet = new ClientboundLevelChunkWithLightPacket(levelChunk, levelChunk.D().l_(), null, null, true);
                    }
                }
                super.write(channelHandlerContext, packet, channelPromise);
            }
        };
        ChannelPipeline pipeline = ((CraftPlayer)player).getHandle().b.a.m.pipeline();
        pipeline.addBefore("packet_handler", player.getName() + "_vivaldi", (ChannelHandler)channelDuplexHandler);
    }

    private void removePlayer(Player player) {
        Channel channel = ((CraftPlayer)player).getHandle().b.a.m;
        channel.eventLoop().submit(() -> {
            channel.pipeline().remove(player.getName());
            return null;
        });
    }

    @EventHandler
    private void onSeasonChange(SeasonChangeEvent event) {
        this.database.clear();
        for (Chunk chunk : this.world.getLoadedChunks()) {
            this.send(((CraftChunk)chunk).getHandle());
        }
    }

    private void send(net.minecraft.world.level.chunk.Chunk chunk) {
        for (Player player : this.world.getPlayers()) {
            int pvd = Math.min(player.getClientViewDistance() + 1, this.plugin.getServer().getSimulationDistance() + 1);
            int x = player.getLocation().getBlockX() / 16 - chunk.bukkitChunk.getX();
            int z = player.getLocation().getBlockZ() / 16 - chunk.bukkitChunk.getZ();
            if (Math.abs(x) >= pvd || Math.abs(z) >= pvd) continue;
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(chunk, chunk.D().l_(), null, null, true);
            NetworkManager connection = ((CraftPlayer)player).getHandle().b.a;
            connection.a((Packet)packet);
        }
    }

    private void changeBiomes(net.minecraft.world.level.chunk.Chunk chunk) {
        boolean previousSectionHasOnlyAir = false;
        for (ChunkSection section : chunk.d()) {
            if (section.g() < 48) continue;
            if (section.c()) {
                if (previousSectionHasOnlyAir) continue;
                previousSectionHasOnlyAir = true;
            }
            for (int x = 0; x < 4; ++x) {
                for (int z = 0; z < 4; ++z) {
                    for (int y = 0; y < 4; ++y) {
                        Holder defaultBiome = (Holder)section.j().a(x, y, z);
                        Holder<BiomeBase> seasonalBiome = this.searchForReplacement((BiomeBase)defaultBiome.a());
                        if (seasonalBiome == null) continue;
                        section.setBiome(x, y, z, seasonalBiome);
                    }
                }
            }
        }
    }

    private Holder<BiomeBase> searchForReplacement(BiomeBase biome) {
        String key = Objects.requireNonNull(this.registry.b((Object)biome)).b() + ":" + Objects.requireNonNull(this.registry.b((Object)biome)).a();
        BiomeContainer container = VivaldiBiomeFactory.getInstance().getTagMap().get(key);
        if (container != null) {
            return container.getHolder(SeasonAPI.getInstance().getCurrentSeason());
        }
        return null;
    }

    private record ChunkDatabase(JavaPlugin instance) {
        private void load() {
            this.check();
        }

        private void check() {
            try {
                File file = new File(this.instance.getDataFolder(), "chunks.db");
                if (!file.exists() && file.createNewFile()) {
                    this.instance.getLogger().info("Initializing a new chunk database...");
                }
                Class.forName("org.sqlite.JDBC");
                Connection db = DriverManager.getConnection("jdbc:sqlite:" + file.getPath());
                Statement stmt = db.createStatement();
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS chunks('x' BIGINT, 'z' BIGINT, 'season' CHAR(10), UNIQUE('x', 'z', 'season'));");
                stmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.instance.getLogger().severe("Error while loading SQLite Database!");
                this.instance.getServer().getPluginManager().disablePlugin((Plugin)this.instance);
            }
        }

        private void write(Chunk chunk) {
            try {
                Statement stmt = this.openConnection().createStatement();
                stmt.executeUpdate(String.format("INSERT OR IGNORE INTO chunks (x, z, season) VALUES ('%s', '%s', '%s');", chunk.getX(), chunk.getZ(), SeasonAPI.getInstance().getCurrentSeason().toString()));
                stmt.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }

        private Connection openConnection() throws SQLException {
            File file = new File(this.instance.getDataFolder(), "chunks.db");
            return DriverManager.getConnection("jdbc:sqlite:" + file.getPath());
        }

        private Season getSeasonOrNull(Chunk chunk) {
            try {
                String query = String.format("SELECT season FROM chunks WHERE x = %s AND z = %s AND season = '%s';", chunk.getX(), chunk.getZ(), SeasonAPI.getInstance().getCurrentSeason().toString());
                Connection connection = this.openConnection();
                Statement stmt = connection.createStatement();
                ResultSet result = stmt.executeQuery(query);
                Season season = null;
                if (result.next() && result.getString("season") != null) {
                    season = Season.valueOf(result.getString("season"));
                }
                stmt.close();
                connection.close();
                return season;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }

        private void clear() {
            try {
                Connection connection = this.openConnection();
                Statement statement = connection.createStatement();
                statement.executeUpdate("DROP TABLE chunks;");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS chunks('x' BIGINT, 'z' BIGINT, 'season' CHAR(10), UNIQUE('x', 'z', 'season'));");
                statement.close();
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

