/*
 * Decompiled with CFR 0.152.
 */
package me.nologic.vivaldi.v1_18_R2.biome;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Objects;
import me.nologic.vivaldi.base.AbstractBiomeFactory;
import me.nologic.vivaldi.season.Season;
import me.nologic.vivaldi.v1_18_R2.biome.BiomeContainer;
import me.nologic.vivaldi.v1_18_R2.biome.CustomBiome;
import me.nologic.vivaldi.v1_18_R2.gameplay.GameplayManager;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class VivaldiBiomeFactory
extends AbstractBiomeFactory {
    private final JavaPlugin plugin;
    private static VivaldiBiomeFactory instance;
    private final HashMap<String, BiomeContainer> biomeTags;
    private int totalBiomesCreated;
    private static final String[] BIOME_FILES;

    public VivaldiBiomeFactory(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.biomeTags = new HashMap();
    }

    @Override
    public void enable() {
        this.saveBiomesFiles();
        this.injectCustomBiomes();
        this.plugin.getLogger().info("Custom biomes initialization completed! Total custom biomes: " + this.totalBiomesCreated);
    }

    private void saveFile(JavaPlugin plugin, File path, String filename, boolean rewrite) {
        InputStream in = plugin.getResource(filename);
        File outFile = new File(path, filename);
        int lastIndex = filename.lastIndexOf(47);
        File outDir = new File(path, filename.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists() || rewrite) {
                int length;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buffer = new byte[1024];
                while ((length = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void injectCustomBiomes() {
        String[] seasons = new String[]{"spring", "summer", "autumn", "winter"};
        for (File file : Objects.requireNonNull(new File(this.plugin.getDataFolder() + "/biomes").listFiles())) {
            BiomeContainer container = new BiomeContainer();
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
            String name = yaml.getString("name");
            for (String season : seasons) {
                String sky = yaml.getString(season + ".sky-color");
                String fog = yaml.getString(season + ".fog-color");
                String water = yaml.getString(season + ".water-color");
                String waterFog = yaml.getString(season + ".water-fog-color");
                String foliage = yaml.getString(season + ".foliage-color");
                String grass = yaml.getString(season + ".grass-color");
                if (yaml.contains(season + ".flowers")) {
                    for (String tag2 : yaml.getStringList("tags")) {
                        for (String flower : yaml.getStringList(season + ".flowers")) {
                            GameplayManager.getInstance().insertToFlowerMap(Season.valueOf(season.toUpperCase()), tag2, Material.valueOf((String)flower));
                        }
                    }
                }
                float temperature = Float.parseFloat(Objects.requireNonNull(yaml.getString(season + ".temperature")));
                container.insert(Season.valueOf(season.toUpperCase()), this.createBiome(season + "_" + name, sky, fog, water, waterFog, grass, foliage, temperature));
                this.biomeTags.put("vivaldi:" + season + "_" + name, container);
            }
            if (yaml.contains("alternatives")) {
                Objects.requireNonNull(yaml.getConfigurationSection("alternatives")).getKeys(false).forEach(key -> {
                    for (String season : seasons) {
                        String sky = yaml.getString("alternatives." + key + "." + season + ".sky-color");
                        String fog = yaml.getString("alternatives." + key + "." + season + ".fog-color");
                        String water = yaml.getString("alternatives." + key + "." + season + ".water-color");
                        String waterFog = yaml.getString("alternatives." + key + "." + season + ".water-fog-color");
                        String foliage = yaml.getString("alternatives." + key + "." + season + ".foliage-color");
                        String grass = yaml.getString("alternatives." + key + "." + season + ".grass-color");
                        float temperature = Float.parseFloat(Objects.requireNonNull(yaml.getString(season + ".temperature")));
                        container.insert(Season.valueOf(season.toUpperCase()), this.createBiome(season + "_" + key + "_" + name, sky, fog, water, waterFog, grass, foliage, temperature));
                        this.biomeTags.put("vivaldi:" + season + "_" + key + "_" + name, container);
                    }
                });
            }
            yaml.getStringList("tags").forEach(tag -> this.biomeTags.put((String)tag, container));
        }
    }

    private CustomBiome createBiome(String name, String skyColor, String fogColor, String waterColor, String waterFogColor, String grassColor, String foliageColor, float temperature) {
        CustomBiome biome = new CustomBiome(this.plugin);
        biome.setName(name);
        try {
            biome.setSkyColor(this.convert(skyColor));
        }
        catch (NullPointerException ex) {
            this.plugin.getLogger().severe("Detected color converting problem while parsing the sky color of " + name + " custom Vivaldi biome.");
        }
        try {
            biome.setFogColor(this.convert(fogColor));
        }
        catch (NullPointerException ex) {
            this.plugin.getLogger().severe("Detected color converting problem while parsing the fog color of " + name + " custom Vivaldi biome.");
        }
        try {
            biome.setWaterColor(this.convert(waterColor));
        }
        catch (NullPointerException ex) {
            this.plugin.getLogger().severe("Detected color converting problem while parsing the water color of " + name + " custom Vivaldi biome.");
        }
        try {
            biome.setWaterFogColor(this.convert(waterFogColor));
        }
        catch (NullPointerException ex) {
            this.plugin.getLogger().severe("Detected color converting problem while parsing the water fog color of " + name + " custom Vivaldi biome.");
        }
        try {
            biome.setGrassColor(this.convert(grassColor));
        }
        catch (NullPointerException ex) {
            this.plugin.getLogger().severe("Detected color converting problem while parsing the grass color of " + name + " custom Vivaldi biome.");
        }
        try {
            biome.setFoliageColor(this.convert(foliageColor));
        }
        catch (NullPointerException ex) {
            this.plugin.getLogger().severe("Detected color converting problem while parsing the foliage color of " + name + " custom Vivaldi biome.");
        }
        biome.setTemperature(temperature);
        ++this.totalBiomesCreated;
        return biome.build();
    }

    private void saveBiomesFiles() {
        boolean rewrite = this.plugin.getConfig().getBoolean("main-settings.replace-biome-files-on-start");
        if (rewrite) {
            this.plugin.getLogger().info("Custom biome files will be rewritten with default ones! If you want to customize biomes by yourself, you should disable this option in config.yml.");
        }
        for (String biome : BIOME_FILES) {
            File path = new File(this.plugin.getDataFolder() + "/biomes/");
            this.saveFile(this.plugin, path, biome, rewrite);
        }
    }

    @NotNull
    private Integer convert(String color) {
        try {
            return Integer.parseInt(color, 16);
        }
        catch (NumberFormatException ex) {
            this.plugin.getLogger().severe("Caught NumberFormatException while parsing " + color + "!");
            return 0;
        }
    }

    public HashMap<String, BiomeContainer> getTagMap() {
        return this.biomeTags;
    }

    public static VivaldiBiomeFactory getInstance() {
        return instance;
    }

    static {
        BIOME_FILES = new String[]{"plains.yml", "taiga.yml", "badlands.yml", "forest.yml", "dark_forest.yml", "jungle.yml", "birch_forest.yml", "river.yml", "savanna.yml", "desert.yml", "hills.yml", "swamp.yml"};
    }
}

